package com.ejianc.foundation.analyticdatas.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ejianc.foundation.deskTop.vo.StatisticUserVO;
import com.ejianc.foundation.deskTop.vo.TimeAnalysisVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.BehaviorDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.bean.LoginlogsEntity;
import com.ejianc.foundation.analyticdatas.consumer.BehaviorDataAnalyticParam;
import com.ejianc.foundation.analyticdatas.mapper.BehaviorDataAnalyticMapper;
import com.ejianc.foundation.analyticdatas.service.IBehaviorDataAnalyticService;
import com.ejianc.foundation.analyticdatas.service.ILoginlogsService;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class BehaviorDataAnalyticServiceImpl extends BaseServiceImpl<BehaviorDataAnalyticMapper, BehaviorDataAnalyticEntity> implements IBehaviorDataAnalyticService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final static String GET_ADDR_BY_IP = "http://opendata.baidu.com/api.php?query=IPADDR&resource_id=6006&t=IDWORKER&ie=utf8&format=json";

    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BehaviorDataAnalyticMapper behaviorDataAnalyticMapper;
    @Autowired
    private ILoginlogsService iLoginlogsService;

    @Override
    public void registerData(BehaviorDataAnalyticVO behaviorData) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(behaviorData);
        rabbitTemplate.convertAndSend(BehaviorDataAnalyticParam.ANALYTICDATAS_COMMON_QUEUE, mqMessage);
    }

    @Override
    @Transactional
    public void handleBehaviorDatas(String behaviorData) {
        logger.info("待处理的用户行为数据：【{}】", behaviorData);
        BehaviorDataAnalyticVO behaviorDataAnalyticVo = JSONObject.parseObject(behaviorData, BehaviorDataAnalyticVO.class);
        if (StringUtils.isNotBlank(behaviorDataAnalyticVo.getIpAddr())) {
            String ipAddr = behaviorDataAnalyticVo.getIpAddr();
            String getAddrUrl = GET_ADDR_BY_IP.replace("IPADDR", ipAddr).replace("IDWORKER", IdWorker.getId() + "");
            try {
                Map<String, String> params = new HashMap<>();
                Map<String, String> headers = new HashMap<>();
                String addrData = HttpTookit.get(getAddrUrl, "gb2312", params, headers);
                logger.info("addrData=======" + addrData);
                JSONObject addrJson = JSON.parseObject(addrData);
                JSONArray addrDataList = addrJson.getJSONArray("data");
                JSONObject addrDataObj = addrDataList.getJSONObject(0);
                String location = addrDataObj.getString("location");
                if (StringUtils.isNotBlank(location)) {
                    String[] locationArr = location.split(" ");
                    if (locationArr.length > 1) {
                        String address = locationArr[0];
                        String[] addressArr = address.split("省");
                        if (addressArr.length > 1) {
                            behaviorDataAnalyticVo.setProvince(addressArr[0] + "省");
                            behaviorDataAnalyticVo.setCity(addressArr[1]);
                        } else {
                            addressArr = address.split("自治区");
                            if (addressArr.length > 1) {
                                behaviorDataAnalyticVo.setProvince(addressArr[0] + "自治区");
                                behaviorDataAnalyticVo.setCity(addressArr[1]);
                            } else {
                                addressArr = address.split("市");
                                behaviorDataAnalyticVo.setProvince(addressArr[0] + "市");
                                behaviorDataAnalyticVo.setCity(addressArr[1]);
                            }
                        }
                        logger.info("省：{}，市：{}", behaviorDataAnalyticVo.getProvince(), behaviorDataAnalyticVo.getCity());
                        behaviorDataAnalyticVo.setOperators(locationArr[1]);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
            if ("login".equals(behaviorDataAnalyticVo.getEventCode())) {
                LoginlogsEntity loginlogsEntity = new LoginlogsEntity();
                loginlogsEntity.setCity(behaviorDataAnalyticVo.getCity());
                loginlogsEntity.setDeviceId(behaviorDataAnalyticVo.getDeviceId());
                loginlogsEntity.setIpAddr(behaviorDataAnalyticVo.getIpAddr());
                loginlogsEntity.setLoginTime(behaviorDataAnalyticVo.getOperateTime());
                loginlogsEntity.setOperators(behaviorDataAnalyticVo.getOperators());
                loginlogsEntity.setUserCode(behaviorDataAnalyticVo.getUserCode());
                loginlogsEntity.setProvince(behaviorDataAnalyticVo.getProvince());
                loginlogsEntity.setReqFrom(behaviorDataAnalyticVo.getReqFrom());
                loginlogsEntity.setTenantId(behaviorDataAnalyticVo.getTenantId());
                iLoginlogsService.saveOrUpdate(loginlogsEntity, false);
                return;
            }
            logger.info("save BehaviorDataAnalyticEntity = {}", JSONObject.toJSONString(behaviorDataAnalyticVo));
            BehaviorDataAnalyticEntity behaviorDataAnalyticEntity = BeanMapper.map(behaviorDataAnalyticVo, BehaviorDataAnalyticEntity.class);
            behaviorDataAnalyticMapper.insert(behaviorDataAnalyticEntity);
        }
    }

    @Override
    public List<BehaviorDataAnalyticVO> queryProvinceMapData() {
        return behaviorDataAnalyticMapper.queryProvinceMapData();
    }

    @Override
    public List<BehaviorDataAnalyticVO> queryCityMapData(String provinceName) {
        return behaviorDataAnalyticMapper.queryCityMapData(provinceName);
    }

    @Override
    public IPage<BehaviorDataAnalyticVO> queryCountRankPage(Map<String, Object> param) {
        List<BehaviorDataAnalyticVO> voList = new ArrayList<>();
        IPage<BehaviorDataAnalyticVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(param.get("pageIndex").toString()));
        page.setSize(Integer.valueOf(param.get("pageSize").toString()));

        if (param.get("postLevelCode") != null) {
            String query = param.get("postLevelCode").toString();

            QueryParam queryParam = new QueryParam();
            param.remove("postLevelCode");
            queryParam.getParams().put("postLevelCode", new Parameter(QueryParam.IN, Arrays.asList(query.split(","))));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(queryParam);
            List<EmployeeVO> mapList = behaviorDataAnalyticMapper.queryIdmEmployee(wrapper);
            if (ListUtil.isNotEmpty(mapList)) {
                List<Long> userIds = mapList.stream().map(EmployeeVO::getUserId).collect(Collectors.toList());
                param.put("userIds", userIds);
            }


        }
        if (param.get("jobLevelCode") != null) {
            String query = param.get("jobLevelCode").toString();

            QueryParam queryParam = new QueryParam();
            param.remove("jobLevelCode");
            queryParam.getParams().put("jobLevelCode", new Parameter(QueryParam.IN, Arrays.asList(query.split(","))));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(queryParam);
            List<EmployeeVO> mapList = behaviorDataAnalyticMapper.queryIdmEmployee(wrapper);
            if (ListUtil.isNotEmpty(mapList)) {
                List<Long> userIds = mapList.stream().map(EmployeeVO::getUserId).collect(Collectors.toList());
                param.put("userIds", userIds);
            }

        }
        if (param.get("postId") != null) {
            String query = param.get("postId").toString();

            QueryParam queryParam = new QueryParam();
            param.remove("postId");
            queryParam.getParams().put("postId", new Parameter(QueryParam.IN, Arrays.asList(query.split(","))));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(queryParam);
            List<EmployeeVO> mapList = behaviorDataAnalyticMapper.queryIdmEmployee(wrapper);
            if (ListUtil.isNotEmpty(mapList)) {
                List<Long> userIds = mapList.stream().map(EmployeeVO::getUserId).collect(Collectors.toList());
                param.put("userIds", userIds);
            }

        }
        if (param.get("departmentId") != null) {
            String query = param.get("departmentId").toString();

            QueryParam queryParam = new QueryParam();
            param.remove("departmentId");
            queryParam.getParams().put("deptId", new Parameter(QueryParam.IN, Arrays.asList(query.split(","))));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(queryParam);
            List<EmployeeVO> mapList = behaviorDataAnalyticMapper.queryIdmEmployee(wrapper);
            if (ListUtil.isNotEmpty(mapList)) {
                List<Long> userIds = mapList.stream().map(EmployeeVO::getUserId).collect(Collectors.toList());
                param.put("userIds", userIds);
            }

        }
        if (param.get("orgId") != null) {
            String query = param.get("orgId").toString();

            QueryParam queryParam = new QueryParam();
            param.remove("orgId");
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, Arrays.asList(query.split(","))));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(queryParam);
            List<EmployeeVO> mapList = behaviorDataAnalyticMapper.queryIdmEmployee(wrapper);
            if (ListUtil.isNotEmpty(mapList)) {
                List<Long> userIds = mapList.stream().map(EmployeeVO::getUserId).collect(Collectors.toList());
                param.put("userIds", userIds);
            }

        }
        long total = behaviorDataAnalyticMapper.countCountRankPage(param);
        page.setTotal(total);
        if (total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() - 1) * page.getSize();
        param.put("startLine", startLine);
        param.put("pageSize", page.getSize());
        voList = behaviorDataAnalyticMapper.queryCountRankPage(param);
        if ("enterpriseUseAppData".equals(param.get("type"))) {
            if (ListUtil.isNotEmpty(voList)) {
                for (BehaviorDataAnalyticVO analyticVO : voList) {
                    List<String> comNames = behaviorDataAnalyticMapper.queryComNameByAppName(analyticVO.getAppName());
                    analyticVO.setComNames(comNames);
                    analyticVO.setComNums(ListUtil.isNotEmpty(comNames) ? comNames.size() : 0L);
                }
            }
        }
        page.setRecords(voList);
        return page;
    }

    @Override
    public List<BehaviorDataAnalyticVO> queryList(Page<BehaviorDataAnalyticVO> page, QueryWrapper wrapper) {
        return behaviorDataAnalyticMapper.queryList(page, wrapper);
    }

    @Override
    public List<StatisticUserVO> queryUserBusinessCount(Page<StatisticUserVO> page, QueryWrapper wrapper, String order) {
        return behaviorDataAnalyticMapper.queryUserBusinessCount(page, wrapper, order);
    }

    @Override
    public List<StatisticUserVO> queryUserCount(Page<StatisticUserVO> page, QueryWrapper wrapper, String order) {
        return behaviorDataAnalyticMapper.queryUserCount(page, wrapper, order);
    }

    @Override
    public List<TimeAnalysisVO> queryTimeAnalysis(QueryWrapper wrapper) {
        return behaviorDataAnalyticMapper.queryTimeAnalysis(wrapper);
    }

    @Override
    public List<StatisticUserVO> queryOrgCount(QueryWrapper wrapper, String order) {
        return behaviorDataAnalyticMapper.queryOrgCount(wrapper, order);
    }

    @Override
    public List<StatisticUserVO> queryDepartmentCount(Page<StatisticUserVO> page, QueryWrapper wrapper, String order) {
        return behaviorDataAnalyticMapper.queryDepartmentCount(page, wrapper, order);
    }

    @Override
    public List<StatisticUserVO> queryBusinessCount(Page<StatisticUserVO> page, QueryWrapper wrapper, String order) {
        return behaviorDataAnalyticMapper.queryBusinessCount(page, wrapper, order);
    }

    @Override
    public List<EmployeeVO> queryIdmEmployee(QueryWrapper wrapper) {
        return behaviorDataAnalyticMapper.queryIdmEmployee(wrapper);
    }
}
