/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.analyticdatas.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statbilldata"})
public class StatisticBillDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IStatisticBillDataService statisticBillDataService;

    @RequestMapping(value={"/queryTenantDataList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryTenantDataList(@RequestBody QueryParam param) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String today = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)calendar.getTime());
        Page page = new Page();
        page.setSize((long)param.getPageSize());
        page.setCurrent((long)param.getPageIndex());
        int startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() - 1) * param.getPageSize();
        Long total = this.statisticBillDataService.queryStatisticBillTenantRankCount(today);
        if (total > 0L) {
            List<JSONObject> record = this.statisticBillDataService.queryStatisticBillTenantRankPage(today, startLine, param.getPageSize());
            page.setRecords(record);
        }
        page.setTotal(total.longValue());
        return CommonResponse.success((Object)page);
    }

    @RequestMapping(value={"/queryTenantDataThisMonth"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryTenantDataThisMonth(@RequestBody QueryParam param) {
        String thisMonth = DateFormatUtil.formatDate((String)"yyyy-MM", (Date)new Date());
        Page page = new Page();
        page.setSize((long)param.getPageSize());
        page.setCurrent((long)param.getPageIndex());
        int startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() - 1) * param.getPageSize();
        Long total = this.statisticBillDataService.queryStatisticBillTenantRankThisMonthCount(thisMonth);
        if (total > 0L) {
            List<JSONObject> record = this.statisticBillDataService.queryStatisticBillTenantRankThisMonthPage(thisMonth, startLine, param.getPageSize());
            page.setRecords(record);
        }
        page.setTotal(total.longValue());
        return CommonResponse.success((Object)page);
    }
}

