package com.ejianc.business.cefoc.asip.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;


/**
 * 应用-接口
 * 
 * @author generator
 * 
 */
public class AppInterfaceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long appId; // 应用id
    private String interfaceName; // 接口名称
    private String interfaceType; // 接口类型(http，webService)
    private String interfaceIdentification; // 接口标识
    private String interfaceAddress; // 接口地址
    private Integer openFlag; // 是否公开
    private String interfaceDescribe; // 接口描述
    private String httpMode; // 请求方式（GET,POST）
    private String httpAddress; // 请求地址
    private String httpRequestBodyFormat; // 请求体格式（none:无，json,form）
    private String webWsdlAddress; // WSDL地址
    private String webAddress; //命名空间namespace
    private String webOperation; // 操作方法 operation
    private String webService; // service  serviceName
    private String webPort; // port
    private Long sqlDataSourceId; // 数据源
    private String sqlType; // sql类型(select,update.insert,delete)
    private String sqlData; // 具体sql
    private Integer pageFlag; // 是否分页

    private List<AppReqVO> headerReqList;

    private List<AppReqVO> bodyReqList;

    private List<AppReqVO> urlParamReqList;

    private List<AppRespVO> appRespList;
    private List<AppInterfaceErrCodeVO> errorCodeList = new ArrayList<>();

    private Boolean wait; // 是否加入待办
    private String appIconSrc;// 应用图标

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }
    public String getInterfaceName() {
        return interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }
    public String getInterfaceType() {
        return interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }
    public String getInterfaceIdentification() {
        return interfaceIdentification;
    }

    public void setInterfaceIdentification(String interfaceIdentification) {
        this.interfaceIdentification = interfaceIdentification;
    }
    public String getInterfaceAddress() {
        return interfaceAddress;
    }

    public void setInterfaceAddress(String interfaceAddress) {
        this.interfaceAddress = interfaceAddress;
    }
    public Integer getOpenFlag() {
        return openFlag;
    }

    public void setOpenFlag(Integer openFlag) {
        this.openFlag = openFlag;
    }
    public String getInterfaceDescribe() {
        return interfaceDescribe;
    }

    public void setInterfaceDescribe(String interfaceDescribe) {
        this.interfaceDescribe = interfaceDescribe;
    }
    public String getHttpMode() {
        return httpMode;
    }

    public void setHttpMode(String httpMode) {
        this.httpMode = httpMode;
    }
    public String getHttpAddress() {
        return httpAddress;
    }

    public void setHttpAddress(String httpAddress) {
        this.httpAddress = httpAddress;
    }
    public String getHttpRequestBodyFormat() {
        return httpRequestBodyFormat;
    }

    public void setHttpRequestBodyFormat(String httpRequestBodyFormat) {
        this.httpRequestBodyFormat = httpRequestBodyFormat;
    }
    public String getWebWsdlAddress() {
        return webWsdlAddress;
    }

    public void setWebWsdlAddress(String webWsdlAddress) {
        this.webWsdlAddress = webWsdlAddress;
    }
    public String getWebService() {
        return webService;
    }

    public void setWebService(String webService) {
        this.webService = webService;
    }
    public String getWebPort() {
        return webPort;
    }

    public void setWebPort(String webPort) {
        this.webPort = webPort;
    }
    public String getWebOperation() {
        return webOperation;
    }

    public void setWebOperation(String webOperation) {
        this.webOperation = webOperation;
    }
    public String getWebAddress() {
        return webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    @ReferSerialTransfer(referCode="cefoc-asip-appResourceConnect")
    public Long getSqlDataSourceId() {
        return sqlDataSourceId;
    }

    @ReferDeserialTransfer
    public void setSqlDataSourceId(Long sqlDataSourceId) {
        this.sqlDataSourceId = sqlDataSourceId;
    }

    public String getSqlType() {
        return sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getSqlData() {
        return sqlData;
    }

    public void setSqlData(String sqlData) {
        this.sqlData = sqlData;
    }
    public Integer getPageFlag() {
        return pageFlag;
    }

    public void setPageFlag(Integer pageFlag) {
        this.pageFlag = pageFlag;
    }

    public List<AppReqVO> getHeaderReqList() {
        return headerReqList;
    }

    public void setHeaderReqList(List<AppReqVO> headerReqList) {
        this.headerReqList = headerReqList;
    }

    public List<AppReqVO> getBodyReqList() {
        return bodyReqList;
    }

    public void setBodyReqList(List<AppReqVO> bodyReqList) {
        this.bodyReqList = bodyReqList;
    }

    public List<AppReqVO> getUrlParamReqList() {
        return urlParamReqList;
    }

    public void setUrlParamReqList(List<AppReqVO> urlParamReqList) {
        this.urlParamReqList = urlParamReqList;
    }

    public List<AppRespVO> getAppRespList() {
        return appRespList;
    }

    public void setAppRespList(List<AppRespVO> appRespList) {
        this.appRespList = appRespList;
    }

    public Boolean getWait() {
        return wait;
    }

    public void setWait(Boolean wait) {
        this.wait = wait;
    }

    public String getAppIconSrc() {
        return appIconSrc;
    }

    public void setAppIconSrc(String appIconSrc) {
        this.appIconSrc = appIconSrc;
    }

    public List<AppInterfaceErrCodeVO> getErrorCodeList() {
        return errorCodeList;
    }

    public void setErrorCodeList(List<AppInterfaceErrCodeVO> errorCodeList) {
        this.errorCodeList = errorCodeList;
    }
}
