package com.ejianc.business.cefoc.asip.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 应用-接口
 * 
 * @author generator
 * 
 */
 @TableName("ejc_asip_app_interface")
public class AppInterfaceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="app_id")
    private Long appId; // 应用id
    @TableField(value="interface_name")
    private String interfaceName; // 接口名称
    @TableField(value="interface_type")
    private String interfaceType; // 接口类型
    @TableField(value="interface_identification")
    private String interfaceIdentification; // 接口标识
    @TableField(value="interface_address")
    private String interfaceAddress; // 接口地址
    @TableField(value="open_flag")
    private Integer openFlag; // 是否公开
    @TableField(value="interface_describe")
    private String interfaceDescribe; // 接口描述

    /*************http信息*****************/
    @TableField(value="http_mode")
    private String httpMode; // 请求方式
    @TableField(value="http_address")
    private String httpAddress; // 请求地址
    @TableField(value="http_request_body_format")
    private String httpRequestBodyFormat; // 请求体格式


    /*************WebService信息*****************/
    @TableField(value="web_wsdl_address")
    private String webWsdlAddress; // WSDL地址
    @TableField(value="web_service")
    private String webService; // service
    @TableField(value="web_port")
    private String webPort; // port
    @TableField(value="web_operation")
    private String webOperation; // operation
    @TableField(value="web_address")
    private String webAddress; // address


    /*************sql信息*****************/
    @TableField(value="sql_data_source_id")
    private Long sqlDataSourceId; // 数据源
    @TableField(value="sql_type")
    private String sqlType; // sql类型(select,update.insert,delete)
    @TableField(value="sql_data")
    private String sqlData; // 具体sql
    @TableField(value="page_flag")
    private Integer pageFlag; // 是否分页

    @TableField(exist=false)
    @SubEntity(serviceName="appReqService", pidName="reqId")
    private List<AppReqEntity> appReqList = new ArrayList<>(); //

    @TableField(exist=false)
    @SubEntity(serviceName="appRespService", pidName="reqId")
    private List<AppRespEntity> appRespList = new ArrayList<>(); //

    /*************错误码信息*****************/
    @TableField(exist=false)
    @SubEntity(serviceName="errCodeService")
    private List<AppInterfaceErrCodeEntity> errorCodeList = new ArrayList<>(); //

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getInterfaceName() {
        return interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getInterfaceType() {
        return interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getInterfaceIdentification() {
        return interfaceIdentification;
    }

    public void setInterfaceIdentification(String interfaceIdentification) {
        this.interfaceIdentification = interfaceIdentification;
    }

    public String getInterfaceAddress() {
        return interfaceAddress;
    }

    public void setInterfaceAddress(String interfaceAddress) {
        this.interfaceAddress = interfaceAddress;
    }

    public Integer getOpenFlag() {
        return openFlag;
    }

    public void setOpenFlag(Integer openFlag) {
        this.openFlag = openFlag;
    }

    public String getInterfaceDescribe() {
        return interfaceDescribe;
    }

    public void setInterfaceDescribe(String interfaceDescribe) {
        this.interfaceDescribe = interfaceDescribe;
    }

    public String getHttpMode() {
        return httpMode;
    }

    public void setHttpMode(String httpMode) {
        this.httpMode = httpMode;
    }

    public String getHttpAddress() {
        return httpAddress;
    }

    public void setHttpAddress(String httpAddress) {
        this.httpAddress = httpAddress;
    }

    public String getHttpRequestBodyFormat() {
        return httpRequestBodyFormat;
    }

    public void setHttpRequestBodyFormat(String httpRequestBodyFormat) {
        this.httpRequestBodyFormat = httpRequestBodyFormat;
    }

    public String getWebWsdlAddress() {
        return webWsdlAddress;
    }

    public void setWebWsdlAddress(String webWsdlAddress) {
        this.webWsdlAddress = webWsdlAddress;
    }

    public String getWebService() {
        return webService;
    }

    public void setWebService(String webService) {
        this.webService = webService;
    }

    public String getWebPort() {
        return webPort;
    }

    public void setWebPort(String webPort) {
        this.webPort = webPort;
    }

    public String getWebOperation() {
        return webOperation;
    }

    public void setWebOperation(String webOperation) {
        this.webOperation = webOperation;
    }

    public String getWebAddress() {
        return webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public Long getSqlDataSourceId() {
        return sqlDataSourceId;
    }

    public void setSqlDataSourceId(Long sqlDataSourceId) {
        this.sqlDataSourceId = sqlDataSourceId;
    }

    public String getSqlType() {
        return sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getSqlData() {
        return sqlData;
    }

    public void setSqlData(String sqlData) {
        this.sqlData = sqlData;
    }

    public Integer getPageFlag() {
        return pageFlag;
    }

    public void setPageFlag(Integer pageFlag) {
        this.pageFlag = pageFlag;
    }

    public List<AppReqEntity> getAppReqList() {
        return appReqList;
    }

    public void setAppReqList(List<AppReqEntity> appReqList) {
        this.appReqList = appReqList;
    }

    public List<AppRespEntity> getAppRespList() {
        return appRespList;
    }

    public void setAppRespList(List<AppRespEntity> appRespList) {
        this.appRespList = appRespList;
    }

    public List<AppInterfaceErrCodeEntity> getErrorCodeList() {
        return errorCodeList;
    }

    public void setErrorCodeList(List<AppInterfaceErrCodeEntity> errorCodeList) {
        this.errorCodeList = errorCodeList;
    }
}
