package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppAuthConfigEntity;
import com.ejianc.business.cefoc.asip.bean.AppAuthReqParamEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceConstantEntity;
import com.ejianc.business.cefoc.asip.service.IAppAuthConfigService;
import com.ejianc.business.cefoc.asip.vo.AppAuthConfigVO;
import com.ejianc.business.cefoc.asip.vo.AppResourceConstantVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 应用鉴权--参数配置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appAuthConfig")
public class AppAuthConfigController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppAuthConfigService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppAuthConfigVO> saveOrUpdate(@RequestBody AppAuthConfigVO saveOrUpdateVO) {
    	AppAuthConfigEntity entity = BeanMapper.map(saveOrUpdateVO, AppAuthConfigEntity.class);
        if(saveOrUpdateVO.getId()!=null){
            AppAuthConfigEntity old = service.selectById(saveOrUpdateVO.getId());
            entity.setTenantId(old.getTenantId());
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateTime(old.getCreateTime());
            entity.setVersion(old.getVersion());
            entity.setSyncEsFlag(old.getSyncEsFlag());
        }
    	service.saveOrUpdate(entity, false);
    	AppAuthConfigVO vo = BeanMapper.map(entity, AppAuthConfigVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppAuthConfigVO> queryDetail(Long id) {
    	AppAuthConfigEntity entity = service.selectById(id);
    	AppAuthConfigVO vo = BeanMapper.map(entity, AppAuthConfigVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AppAuthConfigVO> vos) {
        service.removeByIds(vos.stream().map(AppAuthConfigVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppAuthConfigVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AppAuthConfigEntity> page = service.queryPage(param,false);
        IPage<AppAuthConfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppAuthConfigVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryAllList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AppAuthConfigVO>> queryAllList(@RequestParam Long appId) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("appId", new Parameter(QueryParam.EQ, appId));

        List<AppAuthConfigEntity> data = service.queryList(param);
        List<AppAuthConfigVO> pageData = BeanMapper.mapList(data, AppAuthConfigVO.class);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAppAuthConfigData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppAuthConfigVO>> refAppAuthConfigData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AppAuthConfigEntity> page = service.queryPage(param,false);
        IPage<AppAuthConfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppAuthConfigVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
