package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.*;
import com.ejianc.business.cefoc.asip.service.IAppCategoryService;
import com.ejianc.business.cefoc.asip.vo.AppCategoryVO;
import com.ejianc.business.cefoc.asip.vo.PublishDataVO;
import com.ejianc.business.cefoc.asip.vo.PublishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 应用分组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appCategory")
public class AppCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IAppCategoryService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppCategoryVO> saveOrUpdate(@RequestBody AppCategoryVO saveOrUpdateVO) {
        AppCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, AppCategoryEntity.class);
        if(entity.getId()!=null){
            entity = service.selectById(entity.getId());
            entity.setName(saveOrUpdateVO.getName());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
        service.saveOrUpdate(entity, false);
        AppCategoryVO vo = BeanMapper.map(entity, AppCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppCategoryVO> queryDetail(Long id) {
        AppCategoryEntity entity = service.selectById(id);
        AppCategoryVO vo = BeanMapper.map(entity, AppCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AppCategoryVO> vos) {
        service.removeByIds(vos.stream().map(AppCategoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppCategoryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AppCategoryEntity> page = service.queryPage(param,false);
        IPage<AppCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppCategoryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<AppCategoryVO>> queryAllList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<AppCategoryEntity> data = service.queryList(param,false);
        List<AppCategoryVO> list = new ArrayList<>();
        if(data!=null && data.size()>0){
            list = BeanMapper.mapList(data, AppCategoryVO.class);
        }
        return CommonResponse.success("查询列表数据成功！",list);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AppCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CefocAsipAppCategory-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCefocAsipAppCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppCategoryVO>> refCefocAsipAppCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                            String condition,
                                                                            String searchObject,
                                                                            String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AppCategoryEntity> page = service.queryPage(param,false);
        IPage<AppCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppCategoryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    /**
     * 发布数据
     *
     * @param
     * @return
     */
    @SuppressWarnings("unchecked")
    @ResponseBody
    @RequestMapping(value = "publish")
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank(targetEnv)) {
                return CommonResponse.error("发布数据失败:目标环境域名不能为空!");
            }
            String scope = publishVO.getScope();
            if (StringUtils.isBlank(scope)) {
                return CommonResponse.error("发布数据失败:数据范围不能为空!");
            }

            List<AppCategoryEntity> appCategoryEntities = (List<AppCategoryEntity>) service.listByIds(publishVO.getIdList());

            PublishDataVO publishDataVO = new PublishDataVO();
            if(appCategoryEntities!=null && appCategoryEntities.size()>0){
                appCategoryEntities.forEach(e -> {e.setCreateUserCode(null);e.setCreateTime(null);e.setUpdateUserCode(null);e.setUpdateTime(null);});
            }
            publishDataVO.setAppCategoryEntities(appCategoryEntities);
            publishDataVO.setType("appCategory");

            String url = publishVO.getTarget() + "/cefoc-asip-web/dataTransfer/transferBySql";
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = gson.toJson(publishDataVO);

            logger.info("发布数据的url：---------------"+url);
            try {
                String result = ReferHttpClientUtils.postByJson(url, paramterStr);
                logger.info("发布数据返回的结果：---------------"+result);
                return gson.fromJson(result, CommonResponse.class);
            } catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error("发布数据失败");
            }
        } catch (Exception e) {
            return CommonResponse.error("发布数据失败:" + e.getMessage());
        }
    }
}

