package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AsipApiLog;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 接口请求日志
 *
 */
@Controller
@RequestMapping("asipApiLog")
public class AsipApiLogController implements Serializable {
	private static final long serialVersionUID = -3336617632553785929L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private MongodbCrudTemplate mongodbCrudTemplate;
    @Autowired
    private IAppInterfaceService appInterfaceService;
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AsipApiLog> queryDetail(String id) {
        JSONObject jsonObject = mongodbCrudTemplate.selectById(id, "ejc_asipapi_log");
        AsipApiLog log = null;
        if (jsonObject != null) {
            log = JSONObject.toJavaObject(jsonObject, AsipApiLog.class);
        }
        return CommonResponse.success("查询详情数据成功！",log);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AsipApiLog>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reqParam");
        fuzzyFields.add("respContent");
        IPage<JSONObject> pageData = mongodbCrudTemplate.queryPage(param, "ejc_asipapi_log");
        IPage<AsipApiLog> page = new Page<>();
        page.setCurrent(param.getPageIndex());
        page.setSize(param.getPageSize());
        page.setTotal(pageData.getTotal());
        List<JSONObject> records = pageData.getRecords();
        if(ListUtil.isNotEmpty( records)){
            List<AsipApiLog> list = records.stream().map(jsonObject -> JSONObject.toJavaObject(jsonObject, AsipApiLog.class)).collect(Collectors.toList());
            page.setRecords(list);
        }

        return CommonResponse.success("查询列表数据成功！",page);
    }
}
