package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.cefoc.asip.bean.AppEntity;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.mapper.ApplyInterfaceMapper;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IAppService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import com.ejianc.job.admin.api.IJobAdminApi;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 统计Controller
 * 
 * @author mrsir
 * @date 2025-07-11
 */
@Controller
@RequestMapping(value = "statistics")
public class StatisticsController {

	private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsController.class);

	@Autowired
	private IAppService appService;
	@Autowired
	private IAppInterfaceService interfaceService;
	@Autowired
	private MongodbCrudTemplate mongodbCrudTemplate;
	@Autowired
	private IJobAdminApi jobAdminApi;
	@Autowired
	private ApplyInterfaceMapper applyInterfaceMapper;

	/**
	 * 获取应用信息 包括应用总数、API服务总数，API调用次数
	 * */
	@ResponseBody
	@GetMapping(value = "getAppInfos")
	public CommonResponse<JSONObject> getAppInfos() {
		JSONObject result = new JSONObject();
		List<AppEntity> appList = appService.list(new QueryWrapper<AppEntity>().eq("dr",0));
		result.put("allAppNum", appList.size());
		List<AppInterfaceEntity> interfaceList = interfaceService.list(new QueryWrapper<AppInterfaceEntity>().eq("dr",0));
		result.put("allAPINum", interfaceList.size());
		QueryParam queryParam = QueryParam.getInstance();
		queryParam.setPageSize(-1);
		IPage<JSONObject> records = mongodbCrudTemplate.queryPage(queryParam, "ejc_asipapi_log");
		result.put("allAPICallNum", records.getRecords().size());
		return CommonResponse.success("查询成功",result);
	}

	/**
	 * 获取定时任务信息 包括任务总数、任务调用总数，执行器数
	 * */
	@ResponseBody
	@GetMapping(value = "getJobInfos")
	public CommonResponse<Map<String, Object>> getJobInfos() {
		CommonResponse<Map<String, Object>> response = jobAdminApi.dashboardInfo();
		Map<String, Object> result = response.getData();
		return CommonResponse.success("查询成功",result);
	}
	@ResponseBody
	@GetMapping(value = "getAppAndApiInfo")
	public CommonResponse<List<JSONObject>> getAppAndApiInfo() {
		return CommonResponse.success("查询成功",appService.getAppAndApiInfo());
	}

	@ResponseBody
	@GetMapping(value = "getMyApiInfo")
	public CommonResponse<JSONObject> getMyApiInfo() {
		JSONObject result = new JSONObject();
		Integer count = applyInterfaceMapper.getApplyInterfaceCount(InvocationInfoProxy.getUserid());
		result.put("myApiNum", count);
		QueryParam queryParam = QueryParam.getInstance();
		queryParam.setPageSize(-1);
		queryParam.getParams().put("userId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
		String startOfDay = DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 00:00:00";
		String endOfDay = DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59";
		queryParam.getParams().put("reqTime", new Parameter(QueryParam.BETWEEN, startOfDay+","+endOfDay));
		IPage<JSONObject> records = mongodbCrudTemplate.queryPage(queryParam, "ejc_asipapi_log");
		result.put("myApiCallNum", records.getRecords().size());
		return CommonResponse.success("查询成功",result);
	}

	@ResponseBody
	@GetMapping(value = "pieAndBarInfo")
	public CommonResponse<Map<String, Object>> pieAndBarInfo(@RequestParam(required = false) String startDateStr, @RequestParam(required = false) String endDateStr) {
		if(startDateStr == null){
			startDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtils.addDays(new Date(), -8)) + " 00:00:00";
		}
		if(endDateStr == null){
			endDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtils.addDays(new Date(), -1)) + " 23:59:59";
		}
		return jobAdminApi.pieAndBarInfo(startDateStr, endDateStr);
	}
}
