package com.ejianc.business.cefoc.asip.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IInterfaceHandlerService;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AsipApiLog;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

@Controller
public class InterfaceHandler implements Serializable {
    private static final long serialVersionUID = -7187097338964236420L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MongodbCrudTemplate mongodbCrudTemplate;
    @Autowired
    private IInterfaceHandlerService interfaceHandlerService;
    @Autowired
    private IAppInterfaceService appInterfaceService;

    /**
     * 处理http接口请求
     *
     * @return
     */
    @PostMapping("http/handler/{interfaceCode}")
    @ResponseBody
    public CommonResponse<Object> httpHandler(HttpServletRequest request, @RequestBody JSONObject params, @PathVariable("interfaceCode") String interfaceCode){
        // 使用request.getHeader()直接获取字符串值，并添加空值检查
        String currApiLogId = request.getHeader("currApiLogId");
        logger.info("interfaceCode={} currApiLogId = {} ",interfaceCode,currApiLogId);
        AppInterfaceVO appInterface = appInterfaceService.queryDetail(Long.parseLong(request.getHeader("apiId")));
        CommonResponse<Object> res = interfaceHandlerService.httpHandler(params, appInterface, interfaceCode, request);
        AsipApiLog asipApiLog = new AsipApiLog();
        asipApiLog.setId(currApiLogId);
        asipApiLog.setReqParam(params.toJSONString());
        asipApiLog.setRespContent(JSONObject.toJSONString(res));
        asipApiLog.setApiId(request.getHeader("apiId"));
        asipApiLog.setUserId(request.getHeader("asipUserId"));
        asipApiLog.setReqTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        asipApiLog.setRespStatus(HttpStatus.OK.value()+"");
        if(appInterface!=null){
            asipApiLog.setInterfaceName(appInterface.getInterfaceName());
            asipApiLog.setInterfaceType(appInterface.getInterfaceType());
            asipApiLog.setInterfaceAddress(appInterface.getInterfaceAddress());
        }
        mongodbCrudTemplate.insertOrUpdate(JSONObject.parseObject(JSONObject.toJSONString(asipApiLog)), "ejc_asipapi_log");
        return res;
    }


    /**
     * 处理webservice接口请求
     *
     * @return
     */
    @PostMapping("ws/handler/{interfaceCode}")
    @ResponseBody
    public CommonResponse<Object> wsHandler(HttpServletRequest request, @RequestBody Map<String, Object> params, @PathVariable("interfaceCode") String interfaceCode){
        // 使用request.getHeader()直接获取字符串值，并添加空值检查
        String currApiLogId = request.getHeader("currApiLogId");
        logger.info("interfaceCode={} currApiLogId = {} ",interfaceCode,currApiLogId);
        AppInterfaceVO appInterface = appInterfaceService.queryDetail(Long.parseLong(request.getHeader("apiId")));
        CommonResponse<Object> res = interfaceHandlerService.wsHandler(params, appInterface,interfaceCode, request);
        AsipApiLog asipApiLog = new AsipApiLog();
        asipApiLog.setId(currApiLogId);
        asipApiLog.setUserId(request.getHeader("asipUserId"));
        asipApiLog.setRespContent(JSONObject.toJSONString(res));
        asipApiLog.setReqParam(JSONObject.toJSONString(params));
        asipApiLog.setReqTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        asipApiLog.setApiId(request.getHeader("apiId"));
        asipApiLog.setRespStatus(HttpStatus.OK.value()+"");
        if(appInterface!=null){
            asipApiLog.setInterfaceType(appInterface.getInterfaceType());
            asipApiLog.setInterfaceName(appInterface.getInterfaceName());
            asipApiLog.setInterfaceAddress(appInterface.getInterfaceAddress());
        }
        mongodbCrudTemplate.insertOrUpdate(JSONObject.parseObject(JSONObject.toJSONString(asipApiLog)), "ejc_asipapi_log");
        return res;
    }


    /**
     * 处理sql接口请求
     *
     * @return
     */
    @PostMapping("sql/handler/{interfaceCode}")
    @ResponseBody
    public CommonResponse<Object> sqlHandler(HttpServletRequest request, @RequestBody JSONObject params,@PathVariable("interfaceCode") String interfaceCode){
        String currApiLogId = request.getHeader("currApiLogId");
        logger.info("interfaceCode={} currApiLogId = {} ",interfaceCode,currApiLogId);
        AppInterfaceVO appInterface = appInterfaceService.queryDetail(Long.parseLong(request.getHeader("apiId")));
        CommonResponse<Object> res = interfaceHandlerService.sqlHandler(params, appInterface,interfaceCode,request);
        AsipApiLog asipApiLog = new AsipApiLog();
        asipApiLog.setId(currApiLogId);
        asipApiLog.setReqParam(JSONObject.toJSONString(params));
        asipApiLog.setUserId(request.getHeader("asipUserId"));
        asipApiLog.setRespContent(JSONObject.toJSONString(res));
        asipApiLog.setReqTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        asipApiLog.setRespStatus(HttpStatus.OK.value()+"");
        asipApiLog.setApiId(request.getHeader("apiId"));
        if(appInterface!=null){
            asipApiLog.setInterfaceType(appInterface.getInterfaceType());
            asipApiLog.setInterfaceName(appInterface.getInterfaceName());
            asipApiLog.setInterfaceAddress(appInterface.getInterfaceAddress());
        }
        mongodbCrudTemplate.insertOrUpdate(JSONObject.parseObject(JSONObject.toJSONString(asipApiLog)), "ejc_asipapi_log");
        return res;
    }
}
