package com.ejianc.business.cefoc.asip.service;

import com.ejianc.business.cefoc.asip.vo.WsdlConfig;

import java.util.Map;
import cn.hutool.http.webservice.SoapClient;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.wsdl.WSDLManager;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import javax.wsdl.*;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * WSDL动态调用服务
 */
public class WebServiceClientUtil {
    
    /**
     * 动态调用WSDL接口
     * @param config WSDL配置
     * @param params 调用参数
     * @return 调用结果
     * @throws Exception 异常信息
     */
    public static String callWebService(WsdlConfig config, Map<String, Object> params) throws Exception {
        // 创建SoapClient实例 wsdl协议请求地址:http://xxx.cn/services/GanSuInterface (去掉?wsdl)
        SoapClient client = SoapClient.create(config.getWsdlUrl())
                // 设置方法名和命名空间（命名空间url:http://webservice.xxx.xxx ，方法名:getSydwJsonList）
                // tns 命名空间targetNamespace，没有命名空间时直接写方法名即可
                .setMethod("tns:"+config.getOperationName(), config.getNamespace())
                .setParams(params);
        // 发送请求（true表示输出的结果格式化处理）
        String send = client.send(false);
        Document document = DocumentHelper.parseText(send);
        Element root = document.getRootElement();
        return root.getStringValue();
    }

    /**
     * 获取WSDL接口信息
     * @param wsdlUrl WSDL地址
     * @return WSDL接口信息
     * @throws Exception
     */
    public static WsdlConfig parseWsdl(String wsdlUrl) throws Exception {
        WsdlConfig config = new WsdlConfig();
        config.setWsdlUrl(wsdlUrl);

        // 解析WSDL
        // 正确初始化WSDL解析器
        Bus bus = BusFactory.getDefaultBus();
        WSDLManager manager = bus.getExtension(WSDLManager.class);
        Definition definition = manager.getDefinition(wsdlUrl);
        // 获取命名空间
        config.setNamespace(definition.getTargetNamespace());

        // 获取第一个服务
        Collection<Service> services = definition.getServices().values();
        if (!services.isEmpty()) {
            Service service = services.iterator().next();
            config.setServiceName(service.getQName().getLocalPart());

            // 获取第一个端口
            Collection<Port> ports = service.getPorts().values();
            if (!ports.isEmpty()) {
                Port port = ports.iterator().next();
                config.setPortName(port.getName());

                // 获取所有操作名
                List<BindingOperation> operations = port.getBinding().getBindingOperations();
                List<String> operationNames = operations.stream().map(BindingOperation::getName).collect(Collectors.toList());
                config.setMethods(operationNames);
            }
        }
        return config;
    }
}
