package com.ejianc.business.cefoc.asip.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cefoc.asip.bean.AppAuthEntity;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureEntity;
import com.ejianc.business.cefoc.asip.mapper.DataTransferMapper;
import com.ejianc.business.cefoc.asip.service.*;
import com.ejianc.business.cefoc.asip.vo.PublishDataVO;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class DataTransferService implements IDataTransferService {

	private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private DataTransferMapper dataTransferMapper;
	@Autowired
	private IAppCategoryService appCategoryService;
	@Autowired
	private SqlSessionTemplate sqlSessionTemplate;
	@Autowired
	private IAppAuthConfigService appAuthConfigService;
	@Autowired
	private IAppAuthReqParamService appAuthReqParamService;
	@Autowired
	private IAppAuthService appAuthService;
	@Autowired
	private IAppInterfaceService appInterfaceService;
	@Autowired
	private IAppReqService appReqService;
	@Autowired
	private IAppResourceConnectService appResourceConnectService;
	@Autowired
	private IAppResourceConstantService appResourceConstantService;
	@Autowired
	private IAppResourceDataStructureParamService appResourceDataStructureParamService;
	@Autowired
	private IAppResourceDataStructureService appResourceDataStructureService;
	@Autowired
	private IAppResourceLogicService appResourceLogicService;
	@Autowired
	private IAppRespService appRespService;
	@Autowired
	private IAppService appService;


	@Override
	public void transferBySql(PublishDataVO vo) {
		/*************应用分组start*************/
		if("appCategory".equals(vo.getType())){
			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String baseTableName = "cefoc_asip_app_category";
			String deleteBaseSql = " delete from " + baseTableName + " where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteBaseSql);

			if(vo.getAppCategoryEntities()!=null && vo.getAppCategoryEntities().size()>0){
				appCategoryService.saveOrUpdateBatch(vo.getAppCategoryEntities(), vo.getAppCategoryEntities().size(), false);
			}
		}
		/*************应用分组end*************/

		/*************应用start*************/
		if("app".equals(vo.getType())){

			//获取鉴权孙表数据1
			QueryWrapper<AppAuthEntity> wrapper = new QueryWrapper<>();
			wrapper.in("app_id", vo.getIds());
			List<AppAuthEntity> appAuthList = appAuthService.list(wrapper);
			if(appAuthList!=null && appAuthList.size()>0){
				String idStr1 = "";
				for (AppAuthEntity appAuth : appAuthList) {
					idStr1 = idStr1 + "'" + appAuth.getId() + "',";
				}
				idStr1 = "(" + idStr1.substring(0, idStr1.lastIndexOf(",")) + ")";
				String deleteAppAuthReqParamSql = " delete from cefoc_asip_app_auth_req_param where auth_id in " + idStr1 + ";";
				dataTransferMapper.executeSql(deleteAppAuthReqParamSql);

				String deleteAppReqParamSql = " delete from cefoc_asip_app_req where req_id in " + idStr1 + ";";
				dataTransferMapper.executeSql(deleteAppReqParamSql);
			}

			//获取接口孙表数据2
			QueryWrapper<AppInterfaceEntity> appInterfaceWrapper = new QueryWrapper<>();
			appInterfaceWrapper.in("app_id", vo.getIds());
			List<AppInterfaceEntity> appInterfaceList = appInterfaceService.list(appInterfaceWrapper);
			if(appInterfaceList!=null && appInterfaceList.size()>0){
				String idStr1 = "";
				for (AppInterfaceEntity appAuth : appInterfaceList) {
					idStr1 = idStr1 + "'" + appAuth.getId() + "',";
				}
				idStr1 = "(" + idStr1.substring(0, idStr1.lastIndexOf(",")) + ")";
				String deleteAppReqParamSql = " delete from cefoc_asip_app_req where req_id in " + idStr1 + ";";
				dataTransferMapper.executeSql(deleteAppReqParamSql);
				String deleteAppRespParamSql = " delete from cefoc_asip_app_resp where req_id in " + idStr1 + ";";
				dataTransferMapper.executeSql(deleteAppRespParamSql);
			}

			//获取孙表数据3
			QueryWrapper<AppResourceDataStructureEntity> resourceDataStructureWrapper = new QueryWrapper<>();
			resourceDataStructureWrapper.in("app_id", vo.getIds());
			List<AppResourceDataStructureEntity> appResourceDataStructureList = appResourceDataStructureService.list(resourceDataStructureWrapper);
			if(appResourceDataStructureList!=null && appResourceDataStructureList.size()>0){
				String idStr1 = "";
				for (AppResourceDataStructureEntity appAuth : appResourceDataStructureList) {
					idStr1 = idStr1 + "'" + appAuth.getId() + "',";
				}
				idStr1 = "(" + idStr1.substring(0, idStr1.lastIndexOf(",")) + ")";
				String deleteAppAuthReqParamSql = " delete from cefoc_asip_app_data_structure_param where data_structure_id in " + idStr1 + ";";
				dataTransferMapper.executeSql(deleteAppAuthReqParamSql);
			}

			String idStr = "";
			for (Long id : vo.getIds()) {
				idStr = idStr + "'" + id + "',";
			}
			idStr = "(" + idStr.substring(0, idStr.lastIndexOf(",")) + ")";
			String deleteAppSql = " delete from cefoc_asip_app where id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteAppSql);

			String deleteAppAuthSql = " delete from cefoc_asip_app_auth where app_id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteAppAuthSql);

			String deleteAppAuthParamSql = " delete from cefoc_asip_app_auth_param where app_id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteAppAuthParamSql);

			String deleteAppInterfaceSql = " delete from cefoc_asip_app_interface where app_id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteAppInterfaceSql);

			String deleteResourceConnectSql = " delete from cefoc_asip_app_connect where app_id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteResourceConnectSql);

			String deleteResourceConstantSql = " delete from cefoc_asip_app_resource_constant where app_id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteResourceConstantSql);

			String deleteResourceDataStructureSql = " delete from cefoc_asip_app_data_structure where app_id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteResourceDataStructureSql);

			String deleteResourceLogicSql = " delete from cefoc_asip_app_logic where app_id in " + idStr + ";";
			dataTransferMapper.executeSql(deleteResourceLogicSql);

			if(vo.getAppEntities()!=null && vo.getAppEntities().size()>0){
				appService.saveOrUpdateBatch(vo.getAppEntities(), vo.getAppEntities().size(), false);
			}
			if(vo.getAppAuthConfigEntities()!=null && vo.getAppAuthConfigEntities().size()>0){
				appAuthConfigService.saveOrUpdateBatch(vo.getAppAuthConfigEntities(), vo.getAppAuthConfigEntities().size(), false);
			}
			if(vo.getAppAuthEntities()!=null && vo.getAppAuthEntities().size()>0){
				appAuthService.saveOrUpdateBatch(vo.getAppAuthEntities(), vo.getAppAuthEntities().size(), false);
			}
			if(vo.getAppAuthReqParamEntities()!=null && vo.getAppAuthReqParamEntities().size()>0){
				appAuthReqParamService.saveOrUpdateBatch(vo.getAppAuthReqParamEntities(), vo.getAppAuthReqParamEntities().size(), false);
			}
			if(vo.getAppInterfaceEntities()!=null && vo.getAppInterfaceEntities().size()>0){
				appInterfaceService.saveOrUpdateBatch(vo.getAppInterfaceEntities(), vo.getAppInterfaceEntities().size(), false);
			}
			if(vo.getAppReqEntities()!=null && vo.getAppReqEntities().size()>0){
				appReqService.saveOrUpdateBatch(vo.getAppReqEntities(), vo.getAppReqEntities().size(), false);
			}
			if(vo.getAppResourceConnectEntities()!=null && vo.getAppResourceConnectEntities().size()>0){
				appResourceConnectService.saveOrUpdateBatch(vo.getAppResourceConnectEntities(), vo.getAppResourceConnectEntities().size(), false);
			}
			if(vo.getAppResourceConstantEntities()!=null && vo.getAppResourceConstantEntities().size()>0){
				appResourceConstantService.saveOrUpdateBatch(vo.getAppResourceConstantEntities(), vo.getAppResourceConstantEntities().size(), false);
			}
			if(vo.getAppResourceDataStructureEntities()!=null && vo.getAppResourceDataStructureEntities().size()>0){
				appResourceDataStructureService.saveOrUpdateBatch(vo.getAppResourceDataStructureEntities(), vo.getAppResourceDataStructureEntities().size(), false);
			}
			if(vo.getAppResourceLogicEntities()!=null && vo.getAppResourceLogicEntities().size()>0){
				appResourceLogicService.saveOrUpdateBatch(vo.getAppResourceLogicEntities(), vo.getAppResourceLogicEntities().size(), false);
			}
			if(vo.getAppRespEntities()!=null && vo.getAppRespEntities().size()>0){
				appRespService.saveOrUpdateBatch(vo.getAppRespEntities(), vo.getAppRespEntities().size(), false);
			}
			if(vo.getAppResourceDataStructureParamEntities()!=null && vo.getAppResourceDataStructureParamEntities().size()>0){
				appResourceDataStructureParamService.saveOrUpdateBatch(vo.getAppResourceDataStructureParamEntities(), vo.getAppResourceDataStructureParamEntities().size(), false);
			}
		}
		/*************应用end*************/


	}

}
