package com.ejianc.business.cefoc.asip.utils.sql.dataprovider;

import com.ejianc.business.cefoc.asip.utils.sql.config.AggConfig;
import com.ejianc.business.cefoc.asip.utils.sql.result.AggregateResult;

import java.util.Map;

public interface Aggregatable {

    /**
     * The data provider that support DataSource side Aggregation must implement this method.
     *
     * @param columnName
     * @return
     */
    String[] queryDimVals(String columnName, AggConfig config) throws Exception;

    /**
     * The data provider that support DataSource side Aggregation must implement this method.
     *
     * @return
     */
    String[] getColumn(boolean reload) throws Exception;

	Map<String, String> getSelectColumn(boolean reload) throws Exception;

    /**
     * The data provider that support DataSource side Aggregation must implement this method.
     *
     * @param ac aggregate configuration
     * @return
     */
    AggregateResult queryAggData(AggConfig ac) throws Exception;

    default String viewAggDataQuery(AggConfig ac) throws Exception {
        return "Not Support";
    }

}
