/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IInterfaceHandlerService;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AsipApiLog;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class InterfaceHandler
implements Serializable {
    private static final long serialVersionUID = -7187097338964236420L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MongodbCrudTemplate mongodbCrudTemplate;
    @Autowired
    private IInterfaceHandlerService interfaceHandlerService;
    @Autowired
    private IAppInterfaceService appInterfaceService;

    @PostMapping(value={"http/handler/{interfaceCode}"})
    @ResponseBody
    public CommonResponse<Object> httpHandler(HttpServletRequest request, @RequestBody JSONObject params, @PathVariable(value="interfaceCode") String interfaceCode) {
        String currApiLogId = request.getHeader("currApiLogId");
        this.logger.info("interfaceCode={} currApiLogId = {} ", (Object)interfaceCode, (Object)currApiLogId);
        AppInterfaceVO appInterface = this.appInterfaceService.queryDetail(Long.parseLong(request.getHeader("apiId")));
        CommonResponse<Object> res = this.interfaceHandlerService.httpHandler(params, appInterface, interfaceCode, request);
        AsipApiLog asipApiLog = new AsipApiLog();
        asipApiLog.setId(currApiLogId);
        asipApiLog.setReqParam(params.toJSONString());
        asipApiLog.setRespContent(JSONObject.toJSONString(res));
        asipApiLog.setApiId(request.getHeader("apiId"));
        asipApiLog.setUserId(request.getHeader("asipUserId"));
        asipApiLog.setReqTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        asipApiLog.setRespStatus(HttpStatus.OK.value() + "");
        if (appInterface != null) {
            asipApiLog.setInterfaceName(appInterface.getInterfaceName());
            asipApiLog.setInterfaceType(appInterface.getInterfaceType());
            asipApiLog.setInterfaceAddress(appInterface.getInterfaceAddress());
        }
        this.mongodbCrudTemplate.insertOrUpdate(JSONObject.parseObject((String)JSONObject.toJSONString((Object)asipApiLog)), "ejc_asipapi_log");
        return res;
    }

    @PostMapping(value={"ws/handler/{interfaceCode}"})
    @ResponseBody
    public CommonResponse<Object> wsHandler(HttpServletRequest request, @RequestBody Map<String, Object> params, @PathVariable(value="interfaceCode") String interfaceCode) {
        String currApiLogId = request.getHeader("currApiLogId");
        this.logger.info("interfaceCode={} currApiLogId = {} ", (Object)interfaceCode, (Object)currApiLogId);
        AppInterfaceVO appInterface = this.appInterfaceService.queryDetail(Long.parseLong(request.getHeader("apiId")));
        CommonResponse<Object> res = this.interfaceHandlerService.wsHandler(params, appInterface, interfaceCode, request);
        AsipApiLog asipApiLog = new AsipApiLog();
        asipApiLog.setId(currApiLogId);
        asipApiLog.setUserId(request.getHeader("asipUserId"));
        asipApiLog.setRespContent(JSONObject.toJSONString(res));
        asipApiLog.setReqParam(JSONObject.toJSONString(params));
        asipApiLog.setReqTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        asipApiLog.setApiId(request.getHeader("apiId"));
        asipApiLog.setRespStatus(HttpStatus.OK.value() + "");
        if (appInterface != null) {
            asipApiLog.setInterfaceType(appInterface.getInterfaceType());
            asipApiLog.setInterfaceName(appInterface.getInterfaceName());
            asipApiLog.setInterfaceAddress(appInterface.getInterfaceAddress());
        }
        this.mongodbCrudTemplate.insertOrUpdate(JSONObject.parseObject((String)JSONObject.toJSONString((Object)asipApiLog)), "ejc_asipapi_log");
        return res;
    }

    @PostMapping(value={"sql/handler/{interfaceCode}"})
    @ResponseBody
    public CommonResponse<Object> sqlHandler(HttpServletRequest request, @RequestBody JSONObject params, @PathVariable(value="interfaceCode") String interfaceCode) {
        String currApiLogId = request.getHeader("currApiLogId");
        this.logger.info("interfaceCode={} currApiLogId = {} ", (Object)interfaceCode, (Object)currApiLogId);
        AppInterfaceVO appInterface = this.appInterfaceService.queryDetail(Long.parseLong(request.getHeader("apiId")));
        CommonResponse<Object> res = this.interfaceHandlerService.sqlHandler(params, appInterface, interfaceCode, request);
        AsipApiLog asipApiLog = new AsipApiLog();
        asipApiLog.setId(currApiLogId);
        asipApiLog.setReqParam(JSONObject.toJSONString((Object)params));
        asipApiLog.setUserId(request.getHeader("asipUserId"));
        asipApiLog.setRespContent(JSONObject.toJSONString(res));
        asipApiLog.setReqTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        asipApiLog.setRespStatus(HttpStatus.OK.value() + "");
        asipApiLog.setApiId(request.getHeader("apiId"));
        if (appInterface != null) {
            asipApiLog.setInterfaceType(appInterface.getInterfaceType());
            asipApiLog.setInterfaceName(appInterface.getInterfaceName());
            asipApiLog.setInterfaceAddress(appInterface.getInterfaceAddress());
        }
        this.mongodbCrudTemplate.insertOrUpdate(JSONObject.parseObject((String)JSONObject.toJSONString((Object)asipApiLog)), "ejc_asipapi_log");
        return res;
    }
}

