/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.utils;

import com.ejianc.business.cefoc.asip.utils.sql.config.DimensionConfig;
import com.ejianc.business.cefoc.asip.utils.sql.config.ValueConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;

public class SqlSyntaxHelper {
    private Map<String, Integer> columnTypes;

    public String getProjectStr(DimensionConfig config) {
        return config.getColumnName();
    }

    public String getDimMemberStr(DimensionConfig config, int index) {
        switch (this.columnTypes.get(config.getColumnName().toUpperCase())) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 93: 
            case 2005: 
            case 2011: 
            case 2014: {
                return "'" + config.getValues().get(index) + "'";
            }
        }
        return config.getValues().get(index);
    }

    public String getAggStr(ValueConfig vConfig) {
        String aggExp = vConfig.getColumn();
        switch (vConfig.getAggType()) {
            case "sum": {
                return "SUM(" + aggExp + ")";
            }
            case "avg": {
                return "AVG(" + aggExp + ")";
            }
            case "max": {
                return "MAX(" + aggExp + ")";
            }
            case "min": {
                return "MIN(" + aggExp + ")";
            }
            case "distinct": {
                return "COUNT(DISTINCT " + aggExp + ")";
            }
        }
        return "COUNT(" + aggExp + ")";
    }

    public SqlSyntaxHelper setColumnTypes(Map<String, Integer> columnTypes) {
        this.columnTypes = columnTypes;
        return this;
    }

    public String formatTableName(String rawName) {
        String tmp = rawName.replaceAll("\"", "");
        StringJoiner joiner = new StringJoiner(".");
        Arrays.stream(tmp.split("\\.")).forEach(joiner::add);
        return joiner.toString();
    }
}

