package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppResourceConstantEntity;
import com.ejianc.business.cefoc.asip.service.IAppResourceConstantService;
import com.ejianc.business.cefoc.asip.vo.AppResourceConstantVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 应用资源-常量
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appResourceConstant")
public class AppResourceConstantController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppResourceConstantService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppResourceConstantVO> saveOrUpdate(@RequestBody AppResourceConstantVO saveOrUpdateVO) {
    	AppResourceConstantEntity entity = BeanMapper.map(saveOrUpdateVO, AppResourceConstantEntity.class);
        if(entity.getId()!=null){
            entity = service.selectById(entity.getId());
            entity.setConstantName(saveOrUpdateVO.getConstantName());
            entity.setConstantIdentification(saveOrUpdateVO.getConstantIdentification());
            entity.setConstantDescribe(saveOrUpdateVO.getConstantDescribe());
            entity.setConstantType(saveOrUpdateVO.getConstantType());
            entity.setConstantValue(saveOrUpdateVO.getConstantValue());
        }
    	service.saveOrUpdate(entity, false);
    	AppResourceConstantVO vo = BeanMapper.map(entity, AppResourceConstantVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppResourceConstantVO> queryDetail(Long id) {
    	AppResourceConstantEntity entity = service.selectById(id);
    	AppResourceConstantVO vo = BeanMapper.map(entity, AppResourceConstantVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppResourceConstantVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("constantName");
        fuzzyFields.add("constantIdentification");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AppResourceConstantEntity> page = service.queryPage(param,false);
        IPage<AppResourceConstantVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppResourceConstantVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryAllList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AppResourceConstantVO>> queryList(@RequestParam Long appId) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("appId", new Parameter(QueryParam.EQ, appId));

        List<AppResourceConstantEntity> data = service.queryList(param);
        List<AppResourceConstantVO> pageData = BeanMapper.mapList(data, AppResourceConstantVO.class);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAppResourceConstantData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppResourceConstantVO>> refAppResourceConstantData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AppResourceConstantEntity> page = service.queryPage(param,false);
        IPage<AppResourceConstantVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppResourceConstantVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
