package com.ejianc.business.cefoc.asip.controller;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureParamEntity;
import com.ejianc.business.cefoc.asip.service.IAppResourceDataStructureParamService;
import com.ejianc.business.cefoc.asip.vo.AppResourceDataStructureParamVO;

/**
 * 应用资源-数据结构-参数配置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appResourceDataStructureParam")
public class AppResourceDataStructureParamController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppResourceDataStructureParamService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppResourceDataStructureParamVO> saveOrUpdate(@RequestBody AppResourceDataStructureParamVO saveOrUpdateVO) {
    	AppResourceDataStructureParamEntity entity = BeanMapper.map(saveOrUpdateVO, AppResourceDataStructureParamEntity.class);
    	service.saveOrUpdate(entity, false);
    	AppResourceDataStructureParamVO vo = BeanMapper.map(entity, AppResourceDataStructureParamVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppResourceDataStructureParamVO> queryDetail(Long id) {
    	AppResourceDataStructureParamEntity entity = service.selectById(id);
    	AppResourceDataStructureParamVO vo = BeanMapper.map(entity, AppResourceDataStructureParamVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AppResourceDataStructureParamVO> vos) {
        service.removeByIds(vos.stream().map(AppResourceDataStructureParamVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AppResourceDataStructureParamVO>> queryList(Long dataStructureId) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dataStructureId", new Parameter(QueryParam.EQ, dataStructureId));

        List<AppResourceDataStructureParamEntity> records = service.queryList(param,false);
        List<AppResourceDataStructureParamVO> list = BeanMapper.mapList(records, AppResourceDataStructureParamVO.class);
        list = this.createTreeData(list);
        return CommonResponse.success("查询列表数据成功！",list);
    }

    private List<AppResourceDataStructureParamVO> createTreeData(List<AppResourceDataStructureParamVO> list) {
        List<AppResourceDataStructureParamVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        //循环list，放入listMap重
        Map<String, AppResourceDataStructureParamVO> listMap = new HashMap<>();
        for(AppResourceDataStructureParamVO item:list) {
            listMap.put(item.getId().toString(), item);
        }
        for(int i =0; i<list.size(); i++) {
            AppResourceDataStructureParamVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            AppResourceDataStructureParamVO parent = listMap.get(parentId);
            if(parent != null) {
                List<AppResourceDataStructureParamVO> child = (List<AppResourceDataStructureParamVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<AppResourceDataStructureParamVO> children = new ArrayList<AppResourceDataStructureParamVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAppResourceDataStructureParamData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppResourceDataStructureParamVO>> refAppResourceDataStructureParamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AppResourceDataStructureParamEntity> page = service.queryPage(param,false);
        IPage<AppResourceDataStructureParamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppResourceDataStructureParamVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
