package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.ApplyInterfaceEntity;
import com.ejianc.business.cefoc.asip.service.IApplyInterfaceService;
import com.ejianc.business.cefoc.asip.service.IApplyService;
import com.ejianc.business.cefoc.asip.vo.ApplyInterfaceVO;
import com.ejianc.business.cefoc.asip.bean.ApplyEntity;
import com.ejianc.business.cefoc.asip.vo.ApplyVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 申请接口关系表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("applyInterface")
public class ApplyInterfaceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApplyInterfaceService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IApplyService applyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyInterfaceVO> saveOrUpdate(@RequestBody ApplyInterfaceVO saveOrUpdateVO) {
    	ApplyInterfaceEntity entity = BeanMapper.map(saveOrUpdateVO, ApplyInterfaceEntity.class);
    	service.saveOrUpdate(entity, false);
    	ApplyInterfaceVO vo = BeanMapper.map(entity, ApplyInterfaceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @RequestMapping(value = "/saveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveList(@RequestBody List<ApplyInterfaceVO> list) {
        List<ApplyInterfaceEntity> entity = BeanMapper.mapList(list, ApplyInterfaceEntity.class);
    	service.saveOrUpdateBatch(entity, entity.size(), false);
    	return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyInterfaceVO> queryDetail(Long id) {
    	ApplyInterfaceEntity entity = service.selectById(id);
    	ApplyInterfaceVO vo = BeanMapper.map(entity, ApplyInterfaceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyInterfaceVO> vos) {
        service.removeByIds(vos.stream().map(ApplyInterfaceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyInterfaceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ApplyInterfaceEntity> page = service.queryPage(param,false);
        IPage<ApplyInterfaceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyInterfaceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryInterfaceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryInterfaceList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ApplyEntity> page = applyService.queryPage(param,false);
        IPage<ApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyVO.class));
        if(pageData.getRecords()!=null && pageData.getRecords().size()>0){
            List<Long> appIds = new ArrayList<>();
            for (ApplyVO vo : pageData.getRecords()) {
                appIds.add(vo.getId());
            }
            QueryWrapper<ApplyInterfaceEntity> wrapper = new QueryWrapper<>();
            wrapper.in("apply_id", appIds);
            List<ApplyInterfaceEntity> list = service.list(wrapper);
            Map<Long, List<ApplyInterfaceEntity>> map = new HashMap<>();
            for (ApplyInterfaceEntity en : list) {
                if(map.get(en.getApplyId())!=null){
                    List<ApplyInterfaceEntity> l = map.get(en.getApplyId());
                    l.add(en);
                    map.put(en.getApplyId(), l);
                }else{
                    List<ApplyInterfaceEntity> l = new ArrayList<>();
                    l.add(en);
                    map.put(en.getApplyId(), l);
                }
            }
            for (ApplyVO vo : pageData.getRecords()) {
                if(map.get(vo.getId())!=null){
                    List<ApplyInterfaceEntity> l = map.get(vo.getId());
                    vo.setApplyInterfaceList(BeanMapper.mapList(l, ApplyInterfaceVO.class));
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCefocAsipApplyInterfaceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ApplyInterfaceVO>> refCefocAsipApplyInterfaceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                  String condition,
                                                                                  String searchObject,
                                                                                  String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ApplyInterfaceEntity> page = service.queryPage(param,false);
        IPage<ApplyInterfaceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyInterfaceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
