package com.ejianc.business.cefoc.asip.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.bean.AppAuthEntity;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceConnectEntity;
import com.ejianc.business.cefoc.asip.service.*;
import com.ejianc.business.cefoc.asip.utils.JdbcDataProvider;
import com.ejianc.business.cefoc.asip.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service("interfaceHandlerService")
public class InterfaceHandlerService implements IInterfaceHandlerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppAuthService appAuthService;
    @Autowired
    private IAppInterfaceService appInterfaceService;

    @Autowired
    private IAppResourceConnectService appResourceConnectService;

    /**
     * http请求处理
     *
     * @param params
     * @return
     */
    @Override
    public CommonResponse<Object> httpHandler(JSONObject params,AppInterfaceVO appInterface, String interfaceCode, HttpServletRequest request) {
        if (appInterface == null) {
            logger.error("获取接口信息失败！apiId = {}", request.getHeader("apiId"));
            return CommonResponse.error("接口地址非法！");
        }
        if(!appInterface.getInterfaceIdentification().equals(interfaceCode)){
            logger.error("接口地址非法！appInterface.getInterfaceIdentification = {} --- interfaceCode={}", appInterface.getInterfaceIdentification(),interfaceCode);
            return CommonResponse.error("接口地址非法！");
        }
        AppAuthVO appAuth = appAuthService.queryDetailByAppId(appInterface.getAppId(), "http");
        if (appAuth == null) {
            logger.error("获取接口权限信息失败！appId = {}", appInterface.getAppId());
            return CommonResponse.error("获取接口权限信息失败！");
        }
        int connectTimeout = 20000;
        int readTimeout = 20000;
        if(StringUtils.isNotEmpty(request.getHeader("httpApiConnTimeOut"))){
            connectTimeout = Integer.parseInt(request.getHeader("httpApiConnTimeOut"));
            logger.info("客户自定义httpApiConnTimeOut = {}  appInterface={}", connectTimeout,JSONObject.toJSONString(appInterface));
        }
        if(StringUtils.isNotEmpty(request.getHeader("httpApiReadTimeOut"))){
            readTimeout = Integer.parseInt(request.getHeader("httpApiReadTimeOut"));
            logger.info("客户自定义httpApiReadTimeOut = {}  appInterface={}", readTimeout,JSONObject.toJSONString(appInterface));
        }
        String url = appInterface.getHttpAddress();
        Map<String, String> headers = new HashMap<>();
        if (AppAuthEntity.NO_AUTH.equals(appAuth.getAuthType()) || AppAuthEntity.SIMPLE_AUTH.equals(appAuth.getAuthType())) {
            /** 无鉴权 */
            url = getUrlParam(new JSONObject(), url, appAuth.getUrlParamSetReqList(), appInterface.getUrlParamReqList(),params,request);
            getUrlHeaders(new JSONObject(), appAuth.getHeaderSetReqList(), appInterface.getHeaderReqList(), headers, request);
            if (HttpMethod.GET.name().equals(appInterface.getHttpMode())) {
                try {
                    String result = HttpTookit.get(url, null, headers, connectTimeout, readTimeout);
                    try {
                        JSONObject jsonObject = JSONObject.parseObject(result);
                        return CommonResponse.success("调用成功", jsonObject);
                    } catch (Exception e) {
                    }
                    return CommonResponse.success("调用成功", result);
                } catch (Exception e) {
                    logger.error("调用接口失败！", e);
                    return CommonResponse.error(e.getMessage());
                }
            } else if (HttpMethod.POST.name().equals(appInterface.getHttpMode())) {
                try {
                    String result = null;
                    if (StringUtils.isEmpty(appInterface.getHttpRequestBodyFormat()) || "none".equals(appInterface.getHttpRequestBodyFormat())) {
                        result = HttpTookit.postByJson(url, null, headers, connectTimeout, readTimeout);
                    } else if ("json".equals(appInterface.getHttpRequestBodyFormat())) {
                        params = getUrlBody(new JSONObject(), appAuth.getBodySetReqList(), appInterface.getBodyReqList(), params);
                        result = HttpTookit.postByJson(url, params.toJSONString(), headers, connectTimeout, readTimeout);
                    } else if ("form".equals(appInterface.getHttpRequestBodyFormat())) {
                        Map<String, String> map = getUrlForm(new JSONObject(), appAuth.getBodySetReqList(),appInterface.getBodyReqList(), params);
                        result = HttpTookit.postForm(url, map, headers, "application/x-www-form-urlencoded", connectTimeout, readTimeout);
                    }
                    try {
                        JSONObject jsonObject = JSONObject.parseObject(result);
                        return CommonResponse.success("调用成功", jsonObject);
                    } catch (Exception e) {
                    }
                    return CommonResponse.success("调用成功", result);
                } catch (Exception e) {
                    return CommonResponse.error(e.getMessage());
                }
            }
        } else if (AppAuthEntity.TOKEN_AUTH.equals(appAuth.getAuthType())) {
            /** token 鉴权 */
            /** 先鉴权 ， 获取鉴权数据 */
            CommonResponse<JSONObject> authResponse = getAuthResult(appAuth, true);
            if (!authResponse.isSuccess()) {
                logger.error("调用鉴权接口失败！{}", authResponse.getMsg());
                return CommonResponse.error("参数配置有误！");
            }
            url = getUrlParam(authResponse.getData(), url, appAuth.getUrlParamSetReqList(), appInterface.getUrlParamReqList(),params, request);
            getUrlHeaders(authResponse.getData(), appAuth.getHeaderSetReqList(), appInterface.getHeaderReqList(), headers, request);
            if (HttpMethod.GET.name().equals(appInterface.getHttpMode())) {
                try {
                    String result = HttpTookit.get(url, null, headers, connectTimeout, readTimeout);
                    try {
                        JSONObject jsonObject = JSONObject.parseObject(result);
                        return CommonResponse.success("调用成功", jsonObject);
                    } catch (Exception e) {
                    }
                    return CommonResponse.success("调用成功", result);
                } catch (Exception e) {
                    logger.error("调用接口失败！", e);
                    return CommonResponse.error(e.getMessage());
                }
            } else if (HttpMethod.POST.name().equals(appInterface.getHttpMode())) {
                try {
                    if (StringUtils.isEmpty(appInterface.getHttpRequestBodyFormat())) {
                        return CommonResponse.error("请求参数格式错误！未设置请求体类型！");
                    }
                    String result = null;
                    if ("none".equals(appInterface.getHttpRequestBodyFormat())) {
                        result = HttpTookit.postByJson(url, null, headers, connectTimeout, readTimeout);
                    } else if ("json".equals(appInterface.getHttpRequestBodyFormat())) {
                        params = getUrlBody(authResponse.getData(), appAuth.getBodySetReqList(), appInterface.getBodyReqList(), params);
                        result = HttpTookit.postByJson(url, params.toJSONString(), headers, connectTimeout, readTimeout);
                    } else if ("form".equals(appInterface.getHttpRequestBodyFormat())) {
                        Map<String, String> map = getUrlForm(authResponse.getData(), appAuth.getBodySetReqList(), appInterface.getBodyReqList(),params);
                        result = HttpTookit.postForm(url, map, headers, "application/x-www-form-urlencoded", connectTimeout, readTimeout);
                    }
                    try {
                        JSONObject jsonObject = JSONObject.parseObject(result);
                        return CommonResponse.success("调用成功", jsonObject);
                    } catch (Exception e) {
                    }
                    return CommonResponse.success("调用成功", result);
                } catch (Exception e) {
                    return CommonResponse.error(e.getMessage());
                }
            }
        }
        return CommonResponse.error("调用失败!未知错误！");
    }

    /**
     * 处理webservice接口请求
     *
     * @param params
     * @param log
     * @return
     */
    @Override
    public CommonResponse<Object> wsHandler(Map<String, Object> params, AppInterfaceVO appInterface, String interfaceCode, HttpServletRequest request) {
        // 获取接口信息
        if (appInterface == null) {
            logger.error("获取接口信息失败！apiId = {}", request.getHeader("apiId"));
            return CommonResponse.error("接口地址非法！");
        }
        if(!appInterface.getInterfaceIdentification().equals(interfaceCode)){
            logger.error("接口地址非法！appInterface.getInterfaceIdentification = {} --- interfaceCode={}", appInterface.getInterfaceIdentification(),interfaceCode);
            return CommonResponse.error("接口地址非法！");
        }
        
        // 获取应用鉴权信息
        AppAuthVO appAuth = appAuthService.queryDetailByAppId(appInterface.getAppId(), "webService");
        if (appAuth == null) {
            logger.error("获取接口权限信息失败！appId = {}", appInterface.getAppId());
            return CommonResponse.error("获取接口权限信息失败！");
        }
        
        // 构建WSDL配置
        WsdlConfig config = new WsdlConfig();
        config.setWsdlUrl(appInterface.getWebWsdlAddress());
        config.setNamespace(appInterface.getWebAddress());
        config.setServiceName(appInterface.getWebService());
        config.setPortName(appInterface.getWebPort());
        config.setOperationName(appInterface.getWebOperation());
        try {
            // 调用WebService
            String result = WebServiceClientUtil.callWebService(config, params);
            try {
                JSONObject jsonObject = JSONObject.parseObject(result);
                return CommonResponse.success("调用成功", jsonObject);
            } catch (Exception e) {
            }
            return CommonResponse.success("调用成功", result);
        } catch (Exception e) {
            logger.error("调用WebService失败！", e);
            return CommonResponse.error(e.getMessage());
        }
    }

    /**
     * 处理sql接口请求
     *
     * @param params
     * @return
     */
    @Override
    public CommonResponse<Object> sqlHandler(JSONObject params,  AppInterfaceVO appInterface,String interfaceCode,HttpServletRequest request) {
        // 获取接口信息
        if (appInterface == null) {
            logger.error("获取接口信息失败！apiId = {}", request.getHeader("apiId"));
            return CommonResponse.error("接口地址非法！");
        }
        if(!appInterface.getInterfaceIdentification().equals(interfaceCode)){
            logger.error("接口地址非法！appInterface.getInterfaceIdentification = {} --- interfaceCode={}", appInterface.getInterfaceIdentification(),interfaceCode);
            return CommonResponse.error("接口地址非法！");
        }

        AppResourceConnectEntity uniqueBean = appResourceConnectService.getById(appInterface.getSqlDataSourceId());
        String sql = appInterface.getSqlData();
        List<String> paramList = this.getVariables(sql);
        Map<String, Object> paramMap = new HashMap<>();
        if(paramList!=null && paramList.size()>0){
            for (String p : paramList) {
                sql = sql.replace("${"+p+"}", params.get(p).toString());
            }
        }
        Map<String, String> query = new HashMap<>();
        query.put("sql", sql);
        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        Map<String, String> dataSourceMap = jdbcDataProvider.bulidDataSource(uniqueBean);
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            if("select".equals(appInterface.getSqlType())){
                List<JSONObject> data = jdbcDataProvider.getDataList();
                List<JSONObject> result = new ArrayList<>();
                if(data!=null && data.size()>0){
                    List<AppRespVO> appRespList = appInterface.getAppRespList();
                    Map<String,String> columnMap = new HashMap<>();
                    if(appRespList!=null && appRespList.size()>0){
                        for (AppRespVO appRespVO : appRespList) {
                            columnMap.put(appRespVO.getColumnKey(), appRespVO.getParamName());
                        }
                        for (JSONObject item : data) {
                            JSONObject ob = new JSONObject();
                            for(String key : item.keySet()){
                                if(columnMap.get(key)!=null){
                                    ob.put(columnMap.get(key), item.get(key));
                                }
                            }
                            result.add(ob);
                        }
                    }else{
                        result = data;
                    }
                }
                return CommonResponse.success(result);
            }else{
                Integer re = jdbcDataProvider.executeUpdate();
                return CommonResponse.success(re);
            }
        } catch (Exception e) {
            logger.info("查询sql数据失败----:{}",e.getMessage());
            throw new BusinessException("查询数据失败");
        }
    }

    private void getUrlHeaders(JSONObject authResult, List<AppAuthReqParamVO> headerReqList, List<AppReqVO> urlHeaderReqList, Map<String, String> headers, HttpServletRequest request) {
        if (ListUtil.isNotEmpty(headerReqList)) {
            for (AppAuthReqParamVO appReqVO : headerReqList) {
                String paramValue = request == null ? null : request.getHeader(appReqVO.getParamName());
                if (StringUtils.isEmpty(paramValue)) {
                    if ("formula".equals(appReqVO.getParamFormat())) {
                        //表达式 从鉴权结果中获取
                        String[] keys = appReqVO.getParamValue().split("\\.");
                        for (int i = 1; i < keys.length; i++) {
                            if (i == keys.length - 1) {
                                paramValue = authResult.getString(keys[i]);
                            } else {
                                authResult = authResult.getJSONObject(keys[i]);
                            }
                        }
                    }
                }
                headers.put(appReqVO.getParamName(), paramValue);
            }
        }
        if (ListUtil.isNotEmpty(urlHeaderReqList)) {
            for (AppReqVO appReqVO : urlHeaderReqList) {
                String paramValue = request == null ? null : request.getHeader(appReqVO.getParamName());
                if (request == null) {
                    //request == null 是获取鉴权结果的时候
                    headers.put(appReqVO.getParamName(), appReqVO.getParamValue());
                } else {
                    headers.put(appReqVO.getParamName(), paramValue);
                }
            }
        }
    }

    @Override
    public CommonResponse<JSONObject> getAuthResult(AppAuthVO appAuth,Boolean checkFlag) {
        String url = appAuth.getAddress();
        Map<String, String> headers = new HashMap<>();
        try {
            url = getUrlParam(new JSONObject(), url, null, appAuth.getUrlParamReqList(),new JSONObject(), null);
            getUrlHeaders(new JSONObject(), null, appAuth.getHeaderReqList(), headers, null);
            JSONObject params = new JSONObject();
            if (HttpMethod.GET.name().equals(appAuth.getMode())) {
                try {
                    String result = HttpTookit.get(url, null, headers);
                    if (checkFlag) {
                        checkAuthResult(appAuth, result);
                    }
                    JSONObject authResult = JSONObject.parseObject(result);
                    return CommonResponse.success("调用鉴权成功", authResult);
                } catch (Exception e) {
                    logger.error("调用鉴权接口失败！" + JSONObject.toJSONString(appAuth), e);
                    return CommonResponse.error("调用鉴权接口失败！" + JSONObject.toJSONString(appAuth) + " err = " + e.getMessage());
                }
            } else {
                try {
                    String result = null;
                    if (StringUtils.isEmpty(appAuth.getRequestBodyFormat()) || "none".equals(appAuth.getRequestBodyFormat())) {
                        result = HttpTookit.postByJson(url, null, headers, 20000, 20000);
                        if (checkFlag) {
                            checkAuthResult(appAuth, result);
                        }
                        JSONObject authResult = JSONObject.parseObject(result);
                        return CommonResponse.success("调用鉴权成功", authResult);
                    } else if ("json".equals(appAuth.getRequestBodyFormat())) {
                        if (ListUtil.isNotEmpty(appAuth.getBodyReqList())) {
                            for (AppReqVO appReqVO : appAuth.getBodyReqList()) {
                                if (ListUtil.isNotEmpty(appReqVO.getChildren())) {
                                    for (AppReqVO ch : appReqVO.getChildren()) {
                                        params.put(ch.getParamName(), ch.getParamValue());
                                    }
                                }
                            }
                        }
                        result = HttpTookit.postByJson(url, params.toJSONString(), headers, 20000, 20000);
                        if (checkFlag) {
                            checkAuthResult(appAuth, result);
                        }
                        JSONObject authResult = JSONObject.parseObject(result);
                        return CommonResponse.success("调用鉴权成功", authResult);
                    } else if ("form".equals(appAuth.getRequestBodyFormat())) {
                        Map<String, String> map = new HashMap<>();
                        if (ListUtil.isNotEmpty(appAuth.getBodyReqList())) {
                            for (AppReqVO appReqVO : appAuth.getBodyReqList()) {
                                map.put(appReqVO.getParamName(), appReqVO.getParamValue());
                            }
                        }
                        result = HttpTookit.postForm(url, map, headers, null, 20000, 20000);
                        if (checkFlag) {
                            checkAuthResult(appAuth, result);
                        }
                        JSONObject authResult = JSONObject.parseObject(result);
                        return CommonResponse.success("调用鉴权成功", authResult);
                    }
                } catch (Exception e) {
                    logger.error("调用鉴权接口失败！" + JSONObject.toJSONString(appAuth), e);
                    return CommonResponse.error("调用鉴权接口失败！" + JSONObject.toJSONString(appAuth) + " err = " + e.getMessage());
                }
            }
        } catch (Exception e) {
            return CommonResponse.error(e.getMessage());
        }
        return CommonResponse.error("调用鉴权接口失败！未知错误");
    }

    private void checkAuthResult(AppAuthVO appAuth, String result) throws Exception {
        if (ListUtil.isNotEmpty(appAuth.getHeaderSetReqList())) {
            for (AppAuthReqParamVO appAuthReqParamVO : appAuth.getHeaderSetReqList()) {
                if ("formula".equals(appAuthReqParamVO.getParamFormat())) {
                    String[] keys = appAuthReqParamVO.getParamValue().split("\\.");
                    JSONObject jsonObject = JSONObject.parseObject(result);
                    for (int i = 1; i < keys.length; i++) {
                        if (i == keys.length - 1) {
                            jsonObject.getString(keys[i]);
                        } else {
                            jsonObject = jsonObject.getJSONObject(keys[i]);
                        }
                    }
                }
            }
        }
        if (ListUtil.isNotEmpty(appAuth.getBodySetReqList())) {
            for (AppAuthReqParamVO appAuthReqParamVO : appAuth.getBodySetReqList()) {
                if ("formula".equals(appAuthReqParamVO.getParamFormat())) {
                    String[] keys = appAuthReqParamVO.getParamValue().split("\\.");
                    JSONObject jsonObject = JSONObject.parseObject(result);
                    for (int i = 1; i < keys.length; i++) {
                        if (i == keys.length - 1) {
                            jsonObject.getString(keys[i]);
                        } else {
                            jsonObject = jsonObject.getJSONObject(keys[i]);
                        }
                    }
                }
            }
        }
        if (ListUtil.isNotEmpty(appAuth.getUrlParamSetReqList())) {
            for (AppAuthReqParamVO appAuthReqParamVO : appAuth.getUrlParamSetReqList()) {
                if ("formula".equals(appAuthReqParamVO.getParamFormat())) {
                    String[] keys = appAuthReqParamVO.getParamValue().split("\\.");
                    JSONObject jsonObject = JSONObject.parseObject(result);
                    for (int i = 1; i < keys.length; i++) {
                        if (i == keys.length - 1) {
                            jsonObject.getString(keys[i]);
                        } else {
                            jsonObject = jsonObject.getJSONObject(keys[i]);
                        }
                    }
                }
            }
        }
    }

    private JSONObject getUrlBody(JSONObject authResult, List<AppAuthReqParamVO> bodyReqList, List<AppReqVO> urlBodyReqList, JSONObject body) {
        JSONObject newBody = new JSONObject();
        JSONObject formatBody = new JSONObject();
        //处理下参数过滤,去掉未注册的参数
        List<AppReqVO> children = urlBodyReqList.get(0).getChildren();
        for (AppReqVO childrenReq : children) {
            formatBody.put(childrenReq.getParamName(), body.get(childrenReq.getParamName()));
            newBody.put(childrenReq.getParamName(), body.get(childrenReq.getParamName()));
        }
        newBody.put(urlBodyReqList.get(0).getParamName(), formatBody);
        if (ListUtil.isNotEmpty(bodyReqList)) {
            for (AppAuthReqParamVO appReqVO : bodyReqList) {
                String paramValue = appReqVO.getParamValue();
                if ("formula".equals(appReqVO.getParamFormat())) {
                    //表达式 从鉴权结果中获取
                    String[] keys = appReqVO.getParamValue().split("\\.");
                    for (int i = 1; i < keys.length; i++) {
                        if (i == keys.length - 1) {
                            paramValue = authResult.getString(keys[i]);
                        } else {
                            authResult = authResult.getJSONObject(keys[i]);
                        }
                    }
                }
                newBody.put(appReqVO.getParamName(), paramValue);
            }
        }
        return newBody;
    }

    private Map<String, String> getUrlForm(JSONObject authResult, List<AppAuthReqParamVO> bodyReqList,List<AppReqVO> urlBodyReqList, JSONObject body) {
        Map<String, String> newBody = new HashMap<>();
        if(ListUtil.isNotEmpty(urlBodyReqList)){
            //处理下参数过滤,去掉未注册的参数
            for (AppReqVO childrenReq : urlBodyReqList) {
                newBody.put(childrenReq.getParamName(), body.getString(childrenReq.getParamName()));
            }
        }

        if (ListUtil.isNotEmpty(bodyReqList)) {
            for (AppAuthReqParamVO appReqVO : bodyReqList) {
                String paramValue = appReqVO.getParamValue();
                if ("formula".equals(appReqVO.getParamFormat())) {
                    //表达式 从鉴权结果中获取
                    String[] keys = appReqVO.getParamValue().split("\\.");
                    for (int i = 1; i < keys.length; i++) {
                        if (i == keys.length - 1) {
                            paramValue = authResult.getString(keys[i]);
                        } else {
                            authResult = authResult.getJSONObject(keys[i]);
                        }
                    }
                }
                newBody.put(appReqVO.getParamName(), paramValue);
            }
        }
        return newBody;
    }

    private String getUrlParam(JSONObject authResult, String url, List<AppAuthReqParamVO> paramReqList, List<AppReqVO> urlParamReqList,JSONObject params,HttpServletRequest request) {
        String urlLeft = url.contains("?") ? url.split("\\?")[0] : url;
        StringBuilder urlRight = new StringBuilder(url.contains("?") ? url.split("\\?")[1] : "");
        if (ListUtil.isNotEmpty(paramReqList)) {
            for (AppAuthReqParamVO appReqVO : paramReqList) {
                String paramValue = appReqVO.getParamValue();
                if ("formula".equals(appReqVO.getParamFormat())) {
                    //表达式 从鉴权结果中获取
                    String[] keys = appReqVO.getParamValue().split("\\.");
                    for (int i = 1; i < keys.length; i++) {
                        if (i == keys.length - 1) {
                            paramValue = authResult.getString(keys[i]);
                        } else {
                            authResult = authResult.getJSONObject(keys[i]);
                        }
                    }
                }
                if (!urlRight.toString().contains(appReqVO.getParamName())) {
                    if (urlRight.length() > 0) {
                        urlRight.append("&");
                    }
                    urlRight.append(appReqVO.getParamName()).append("=").append(paramValue);
                }
            }
        }
        if (ListUtil.isNotEmpty(urlParamReqList)) {
            // 从 request 或者 requestBody 里面取值
            for (AppReqVO appReqVO : urlParamReqList) {
                if(request== null){
                    //获取鉴权数据的时候，直接取值，不进行判断
                    if (!urlRight.toString().contains(appReqVO.getParamName())) {
                        if (urlRight.length() > 0) {
                            urlRight.append("&");
                        }
                        urlRight.append(appReqVO.getParamName()).append("=").append(appReqVO.getParamValue());
                    }
                }else {//否则， 从 request 或者 requestBody 里面取值
                    String paramValue = request.getParameter(appReqVO.getParamName());
                    if (StringUtils.isEmpty(paramValue)) {
                        paramValue = params.getString(appReqVO.getParamName());
                    }
                    if (!urlRight.toString().contains(appReqVO.getParamName())) {
                        if (urlRight.length() > 0) {
                            urlRight.append("&");
                        }
                        urlRight.append(appReqVO.getParamName()).append("=").append(paramValue);
                    }
                }
            }
        }
        if (urlRight.length() == 0) {
            return url;
        }
        return urlLeft + "?" + urlRight;
    }

    public List<String> getVariables(String str) {
        List<String> variables = new ArrayList<>();
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }
}
