/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.vo.AsipApiLog;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"asipApiLog"})
public class AsipApiLogController
implements Serializable {
    private static final long serialVersionUID = -3336617632553785929L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MongodbCrudTemplate mongodbCrudTemplate;
    @Autowired
    private IAppInterfaceService appInterfaceService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AsipApiLog> queryDetail(String id) {
        JSONObject jsonObject = this.mongodbCrudTemplate.selectById(id, "ejc_asipapi_log");
        AsipApiLog log = null;
        if (jsonObject != null) {
            log = (AsipApiLog)JSONObject.toJavaObject((JSON)jsonObject, AsipApiLog.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", log);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AsipApiLog>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reqParam");
        fuzzyFields.add("respContent");
        IPage pageData = this.mongodbCrudTemplate.queryPage(param, "ejc_asipapi_log");
        Page page = new Page();
        page.setCurrent((long)param.getPageIndex());
        page.setSize((long)param.getPageSize());
        page.setTotal(pageData.getTotal());
        List records = pageData.getRecords();
        if (ListUtil.isNotEmpty((List)records)) {
            List list = records.stream().map(jsonObject -> (AsipApiLog)JSONObject.toJavaObject((JSON)jsonObject, AsipApiLog.class)).collect(Collectors.toList());
            page.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

