/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.JobInfoEntity;
import com.ejianc.business.cefoc.asip.bean.JobInfoParamEntity;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IJobInfoService;
import com.ejianc.business.cefoc.asip.vo.JobInfoParamVO;
import com.ejianc.business.cefoc.asip.vo.JobInfoVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.job.admin.api.IJobAdminApi;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"jobInfo"})
public class JobInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IJobInfoService service;
    @Autowired
    private IJobAdminApi jobAdminApi;
    @Autowired
    private IAppInterfaceService interfaceService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JobInfoVO> saveOrUpdate(@RequestBody JobInfoVO saveOrUpdateVO) {
        CommonResponse response;
        XxlJobInfo jobInfo;
        JobInfoEntity entity = (JobInfoEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, JobInfoEntity.class));
        JSONObject executorParam = new JSONObject();
        executorParam.put("appIdForJobAdmin", (Object)entity.getAppId());
        executorParam.put("urlIdForJobAdmin", (Object)entity.getUrlId());
        executorParam.put("connTimeOut", (Object)entity.getConnTimeOut());
        executorParam.put("readTimeOut", (Object)entity.getReadTimeOut());
        AppInterfaceEntity appInterfaceEntity = (AppInterfaceEntity)((Object)this.interfaceService.getById(entity.getUrlId()));
        executorParam.put("urlForJobAdmin", (Object)appInterfaceEntity.getInterfaceAddress());
        if (ListUtil.isNotEmpty((List)saveOrUpdateVO.getParamEntities())) {
            for (JobInfoParamVO paramEntity : saveOrUpdateVO.getParamEntities()) {
                if ("del".equals(paramEntity.getRowState())) continue;
                executorParam.put(paramEntity.getParamKey(), (Object)paramEntity.getParamValue());
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCode("JOB-" + UUID.randomUUID().toString().replace("-", "").toLowerCase().substring(0, 10));
            entity.setJobState(false);
            jobInfo = new XxlJobInfo();
            jobInfo.setJobGroup(saveOrUpdateVO.getJobGroup().intValue());
            jobInfo.setJobCron(saveOrUpdateVO.getJobCron());
            jobInfo.setJobDesc(saveOrUpdateVO.getName());
            jobInfo.setAddTime(new Date());
            jobInfo.setExecutorHandler("zdsJCJobHandler");
            jobInfo.setGlueRemark("GLUE\u4ee3\u7801\u521d\u59cb\u5316");
            jobInfo.setGlueType("BEAN");
            jobInfo.setGlueUpdatetime(new Date());
            jobInfo.setExecutorParam(executorParam.toJSONString());
            jobInfo.setExecutorFailRetryCount(2);
            jobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
            jobInfo.setExecutorRouteStrategy("ROUND");
            jobInfo.setExecutorTimeout(100);
            jobInfo.setAlarmEmail("");
            jobInfo.setAuthor(InvocationInfoProxy.getUsercode());
            response = this.jobAdminApi.add(jobInfo);
            if (!response.isSuccess()) {
                this.logger.error("\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01{}", (Object)response.getMsg());
                return CommonResponse.error((String)"\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01");
            }
            jobInfo = (XxlJobInfo)response.getData();
        } else {
            response = this.jobAdminApi.queryOne(entity.getJobId());
            if (!response.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01{}", (Object)response.getMsg());
                return CommonResponse.error((String)"\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01");
            }
            jobInfo = (XxlJobInfo)response.getData();
            jobInfo.setJobCron(saveOrUpdateVO.getJobCron());
            jobInfo.setJobDesc(saveOrUpdateVO.getName());
            jobInfo.setUpdateTime(new Date());
            jobInfo.setExecutorParam(executorParam.toJSONString());
            CommonResponse resp = this.jobAdminApi.update(jobInfo);
            if (!resp.isSuccess()) {
                this.logger.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01{}", (Object)resp.getMsg());
                return CommonResponse.error((String)"\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01");
            }
        }
        entity.setJobId(jobInfo.getId());
        this.service.saveOrUpdate((Object)entity, false);
        JobInfoVO vo = (JobInfoVO)BeanMapper.map((Object)((Object)entity), JobInfoVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JobInfoVO> queryDetail(Long id) {
        JobInfoEntity entity = (JobInfoEntity)((Object)this.service.selectById(id));
        JobInfoVO vo = (JobInfoVO)BeanMapper.map((Object)((Object)entity), JobInfoVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<JobInfoVO> vos) {
        QueryParam param = QueryParam.getInstance();
        param.getParams().put("id", new Parameter("in", vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        List entityList = this.service.queryList(param, false);
        ArrayList<Long> jobIds = new ArrayList<Long>();
        StringBuilder sb = new StringBuilder("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01");
        for (JobInfoEntity entity : entityList) {
            CommonResponse response = this.jobAdminApi.remove(entity.getJobId());
            if (!response.isSuccess()) {
                this.logger.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01{}", (Object)response.getMsg());
                sb.append(response.getMsg());
                continue;
            }
            jobIds.add(entity.getId());
        }
        if (ListUtil.isEmpty(jobIds)) {
            return CommonResponse.error((String)sb.toString());
        }
        this.service.removeByIds(jobIds, true);
        if (jobIds.size() == entityList.size()) {
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)("\u90e8\u5206\u5220\u9664\u6210\u529f\uff01" + jobIds.size() + "\u6761\u6570\u636e\u5220\u9664\u6210\u529f\uff01" + (entityList.size() - jobIds.size()) + "\u6761\u6570\u636e\u5220\u9664\u5931\u8d25\uff01" + sb));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JobInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JobInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("JobInfo-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refJobInfoData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JobInfoVO>> refJobInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), JobInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/start"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> start(Long id) {
        JobInfoEntity entity = (JobInfoEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u542f\u52a8\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25\uff01\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        CommonResponse response = this.jobAdminApi.start(entity.getJobId());
        if (!response.isSuccess()) {
            this.logger.error("\u542f\u52a8\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25\uff01{}", (Object)response.getMsg());
            return response;
        }
        entity.setJobState(true);
        this.service.saveOrUpdate((Object)entity, false);
        return response;
    }

    @RequestMapping(value={"/stop"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> stop(Long id) {
        JobInfoEntity entity = (JobInfoEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u505c\u6b62\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25\uff01\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        CommonResponse response = this.jobAdminApi.stop(entity.getJobId());
        if (!response.isSuccess()) {
            this.logger.error("\u505c\u6b62\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25\uff01{}", (Object)response.getMsg());
            return response;
        }
        entity.setJobState(false);
        this.service.saveOrUpdate((Object)entity, false);
        return response;
    }

    @RequestMapping(value={"/triggerJob"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> triggerJob(Long id) {
        JobInfoEntity entity = (JobInfoEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25\uff01\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject executorParam = new JSONObject();
        executorParam.put("appIdForJobAdmin", (Object)entity.getAppId());
        executorParam.put("urlIdForJobAdmin", (Object)entity.getUrlId());
        executorParam.put("connTimeOut", (Object)entity.getConnTimeOut());
        executorParam.put("readTimeOut", (Object)entity.getReadTimeOut());
        AppInterfaceEntity appInterfaceEntity = (AppInterfaceEntity)((Object)this.interfaceService.getById(entity.getUrlId()));
        executorParam.put("urlForJobAdmin", (Object)appInterfaceEntity.getInterfaceAddress());
        if (ListUtil.isNotEmpty(entity.getParamEntities())) {
            for (JobInfoParamEntity paramEntity : entity.getParamEntities()) {
                if ("del".equals(paramEntity.getRowState())) continue;
                executorParam.put(paramEntity.getParamKey(), (Object)paramEntity.getParamValue());
            }
        }
        return this.jobAdminApi.triggerJob(entity.getJobId().intValue(), executorParam.toJSONString());
    }

    @PostMapping(value={"pageLogList"})
    @ResponseBody
    public CommonResponse<Page<XxlJobLog>> pageLogList(@RequestBody QueryParam param) {
        String filterTime;
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        int jobGroup = param.getParams().get("jobGroup") != null ? Integer.parseInt(((Parameter)param.getParams().get("jobGroup")).getValue().toString()) : 0;
        int jobId = param.getParams().get("jobId") != null ? Integer.parseInt(((Parameter)param.getParams().get("jobId")).getValue().toString()) : 0;
        int logStatus = param.getParams().get("logStatus") != null ? Integer.parseInt(((Parameter)param.getParams().get("logStatus")).getValue().toString()) : -1;
        String string = filterTime = param.getParams().get("filterTime") != null ? ((Parameter)param.getParams().get("filterTime")).getValue().toString() : null;
        if (StringUtils.isNotEmpty(filterTime)) {
            String[] times = filterTime.split(",");
            filterTime = times[0] + " 00:00:00," + times[1] + " 23:59:59";
        }
        return this.jobAdminApi.pageLogList(pageIndex, pageSize, jobGroup, jobId, logStatus, filterTime);
    }

    @GetMapping(value={"logDetailCat"})
    @ResponseBody
    public CommonResponse<String> logDetailCat(@RequestParam String executorAddress, @RequestParam long triggerTime, @RequestParam int logId) {
        return this.jobAdminApi.logDetailCat(executorAddress, triggerTime, logId, 1);
    }
}

