package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppUserRelationEntity;
import com.ejianc.business.cefoc.asip.service.IAppUserRelationService;
import com.ejianc.business.cefoc.asip.vo.AppUserRelationVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 应用用户关系
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appUserRelation")
public class AppUserRelationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAppUserRelationService service;
    @Autowired
    private IUserApi userApi;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveList(@RequestBody List<AppUserRelationVO> list) {
        Long appId = list.get(0).getAppId();
        List<Long> userIds = new ArrayList<>();
        for(AppUserRelationVO vo : list){
            userIds.add(vo.getUserId());
        }
        QueryWrapper<AppUserRelationEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("app_id", appId);
        wrapper.in("user_id", userIds);
        List<AppUserRelationEntity> entitys = service.list(wrapper);
        if(entitys!=null && entitys.size()>0){
            for(AppUserRelationEntity entity : entitys){
                if(userIds.contains(entity.getUserId())){
                    userIds.remove(entity.getUserId());
                }
            }
        }
        List<AppUserRelationEntity> addData = new ArrayList<>();
        if(userIds!=null && userIds.size()>0){
            for(Long userId : userIds){
                AppUserRelationEntity entity = new AppUserRelationEntity();
                entity.setAppId(appId);
                entity.setUserId(userId);
                entity.setType("2");
                addData.add(entity);
            }
            service.saveOrUpdateBatch(addData, addData.size(), false);
        }
    	return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppUserRelationVO> queryDetail(Long id) {
    	AppUserRelationEntity entity = service.selectById(id);
    	AppUserRelationVO vo = BeanMapper.map(entity, AppUserRelationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        service.removeByIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppUserRelationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<AppUserRelationEntity> page = service.queryPage(param,false);
        IPage<AppUserRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppUserRelationVO.class));
        if(pageData.getRecords()!=null && pageData.getRecords().size()>0){
            String[] userIds = new String[pageData.getRecords().size()];
            for (int i=0; i<pageData.getRecords().size(); i++){
                AppUserRelationVO vo = pageData.getRecords().get(i);
                userIds[i] = vo.getUserId().toString();
            }
            CommonResponse<List<UserVO>> userResponse = userApi.queryListByIds(userIds);
            if(userResponse.isSuccess() && userResponse.getData()!=null && userResponse.getData().size()>0){
                Map<Long, UserVO> userMap = new HashMap<>();
                for(UserVO vo : userResponse.getData()){
                    userMap.put(vo.getId(), vo);
                }
                for(AppUserRelationVO vo : pageData.getRecords()){
                    if(userMap.get(vo.getUserId())!=null){
                        vo.setUserName(userMap.get(vo.getUserId()).getUserName());
                        vo.setOrgName(userMap.get(vo.getUserId()).getOrgName());
                    }
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @RequestMapping(value = "/isUserManager", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> isUserManager(Long appId, Long userId) {
        //查询该应用的管理员
        QueryWrapper<AppUserRelationEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("app_id", appId);
        wrapper.eq("user_id", userId);
        wrapper.eq("type", "1");
        AppUserRelationEntity manager = service.getOne(wrapper);
        if(manager!=null){
            return CommonResponse.success(true);
        }
        return CommonResponse.success(false);
    }
    @RequestMapping(value = "/transferManager", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> transferManager(Long appId, Long userId) {
        //查询该应用的管理员
        QueryWrapper<AppUserRelationEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("app_id", appId);
        wrapper.eq("type", "1");
        AppUserRelationEntity manager = service.getOne(wrapper);
        if(manager!=null && manager.getUserId().equals(userId)){
            throw new BusinessException("该用户已是管理员");
        }
        if(manager!=null){
            manager.setType("2");
        }
        //获取该人员是否已有本应用权限
        QueryWrapper<AppUserRelationEntity> wrapper2 = new QueryWrapper<>();
        wrapper2.eq("app_id", appId);
        wrapper2.eq("user_id", userId);
        AppUserRelationEntity user = service.getOne(wrapper2);
        if(user!=null){
            user.setType("1");
        }else{
            user = new AppUserRelationEntity();
            user.setType("1");
            user.setAppId(appId);
            user.setUserId(userId);
        }
        List<AppUserRelationEntity> entitys = new ArrayList<>();
        entitys.add(manager);
        entitys.add(user);
        service.saveOrUpdateBatch(entitys, entitys.size(), false);
        return CommonResponse.success("移交管理员成功！");
    }
}
