package com.ejianc.business.cefoc.asip.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.vo.AppAuthVO;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.framework.core.response.CommonResponse;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public interface IInterfaceHandlerService {
    /**
     * http请求处理
     * @param params
     * @return
     */
    CommonResponse<Object> httpHandler(JSONObject params, AppInterfaceVO appInterface,String interfaceCode, HttpServletRequest request);
    /**
     * 处理webservice接口请求
     * @param params
     * @param log
     * @return
     */
    CommonResponse<Object> wsHandler(Map<String, Object> params, AppInterfaceVO appInterface, String interfaceCode, HttpServletRequest request);
    /**
     * 处理sql接口请求
     * @param params
     * @return
     */
    CommonResponse<Object> sqlHandler(JSONObject params, AppInterfaceVO appInterface,String interfaceCode,HttpServletRequest request);
    /**
     * 获取授权结果
     * @param appAuth
     * @param checkFlag
     * @return
     */
    CommonResponse<JSONObject> getAuthResult(AppAuthVO appAuth, Boolean checkFlag);
}
