package com.ejianc.business.cefoc.asip.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.*;
import com.ejianc.business.cefoc.asip.mapper.AppInterfaceMapper;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IAppResourceConnectService;
import com.ejianc.business.cefoc.asip.service.IAppService;
import com.ejianc.business.cefoc.asip.service.IWaitApplyService;
import com.ejianc.business.cefoc.asip.utils.JdbcDataProvider;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AppReqVO;
import com.ejianc.business.cefoc.asip.vo.AppRespVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 应用-接口
 * 
 * @author generator
 * 
 */
@Service("appInterfaceService")
public class AppInterfaceServiceImpl extends BaseServiceImpl<AppInterfaceMapper, AppInterfaceEntity> implements IAppInterfaceService{

    @Autowired
    private IWaitApplyService waitApplyService;
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppResourceConnectService appResourceConnectService;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public AppInterfaceVO saveData(AppInterfaceVO saveOrUpdateVO) {
        AppInterfaceEntity entity = BeanMapper.map(saveOrUpdateVO, AppInterfaceEntity.class);
        if(entity.getId()!=null){
            AppInterfaceEntity old = this.selectById(entity.getId());
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateUserCode(old.getCreateUserCode());
            entity.setTenantId(old.getTenantId());
            entity.setVersion(old.getVersion());
        }else{
            entity = BeanMapper.map(saveOrUpdateVO, AppInterfaceEntity.class);
        }
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("interfaceIdentification", new Parameter(QueryParam.EQ, entity.getInterfaceIdentification()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, entity.getId()));
        List<AppInterfaceEntity> appInterfaceList = this.queryList(queryParam,false);
        if(!ListUtil.isEmpty(appInterfaceList)){
            throw new BusinessException("接口标识已存在,请更改接口标识！");
        }
        List<AppReqEntity> appReqList = new ArrayList<>(); //
        if(saveOrUpdateVO.getHeaderReqList()!=null && saveOrUpdateVO.getHeaderReqList().size()>0){
            appReqList = BeanMapper.mapList(saveOrUpdateVO.getHeaderReqList(), AppReqEntity.class);
        }
        if(saveOrUpdateVO.getBodyReqList()!=null && saveOrUpdateVO.getBodyReqList().size()>0){
            List<AppReqEntity> paramList = new ArrayList<>();
            paramList = this.dealChildren1(saveOrUpdateVO.getBodyReqList(), paramList, null, "body");
            appReqList.addAll(paramList);
        }
        if(saveOrUpdateVO.getUrlParamReqList()!=null && saveOrUpdateVO.getUrlParamReqList().size()>0){
            appReqList.addAll(BeanMapper.mapList(saveOrUpdateVO.getUrlParamReqList(), AppReqEntity.class));
        }
        entity.setAppReqList(appReqList);

        if(saveOrUpdateVO.getAppRespList()!=null && saveOrUpdateVO.getAppRespList().size()>0){
            List<AppRespEntity> paramList = new ArrayList<>();
            paramList = this.dealChildren2(saveOrUpdateVO.getAppRespList(), paramList, null, "body");
            entity.setAppRespList(paramList);
        }

        this.saveOrUpdate(entity, false);
        AppInterfaceVO vo = BeanMapper.map(entity, AppInterfaceVO.class);
        return null;
    }

    private List<AppReqEntity> dealChildren1(List<AppReqVO> children, List<AppReqEntity> paramList, Long pid, String type) {
        for(AppReqVO param : children){
            param.setPid(pid);
            if("add".equals(param.getRowState())){
                param.setId(IdWorker.getId());
            }
            if(param.getChildren()!=null && param.getChildren().size()>0){
                paramList = this.dealChildren1(param.getChildren(), paramList, param.getId(), type);
            }
            AppReqEntity en = BeanMapper.map(param, AppReqEntity.class);
            en.setType(type);
            paramList.add(en);
        }
        return paramList;
    }

    private List<AppReqVO> createTreeData1(List<AppReqVO> list) {
        List<AppReqVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        //循环list，放入listMap重
        Map<String, AppReqVO> listMap = new HashMap<>();
        for(AppReqVO item:list) {
            listMap.put(item.getId().toString(), item);
        }
        for(int i =0; i<list.size(); i++) {
            AppReqVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            AppReqVO parent = listMap.get(parentId);
            if(parent != null) {
                List<AppReqVO> child = (List<AppReqVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<AppReqVO> children = new ArrayList<AppReqVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private List<AppRespEntity> dealChildren2(List<AppRespVO> children, List<AppRespEntity> paramList, Long pid, String type) {
        for(AppRespVO param : children){
            param.setPid(pid);
            if("add".equals(param.getRowState())){
                param.setId(IdWorker.getId());
            }
            if(param.getChildren()!=null && param.getChildren().size()>0){
                paramList = this.dealChildren2(param.getChildren(), paramList, param.getId(), type);
            }
            AppRespEntity en = BeanMapper.map(param, AppRespEntity.class);
            en.setType(type);
            paramList.add(en);
        }
        return paramList;
    }

    private List<AppRespVO> createTreeData2(List<AppRespVO> list) {
        List<AppRespVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        //循环list，放入listMap重
        Map<String, AppRespVO> listMap = new HashMap<>();
        for(AppRespVO item:list) {
            listMap.put(item.getId().toString(), item);
        }
        for(int i =0; i<list.size(); i++) {
            AppRespVO item = list.get(i);
            String parentId = (item.getPid() != null) ? item.getPid().toString():"";
            AppRespVO parent = listMap.get(parentId);
            if(parent != null) {
                List<AppRespVO> child = (List<AppRespVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<AppRespVO> children = new ArrayList<AppRespVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    @Override
    public AppInterfaceVO queryDetail(Long id) {
        AppInterfaceVO vo = null;
        AppInterfaceEntity entity = this.selectById(id);
        if(entity!=null){
            vo = BeanMapper.map(entity, AppInterfaceVO.class);

            List<AppReqVO> headerReqList = new ArrayList<>();
            List<AppReqVO> bodyReqList = new ArrayList<>();
            List<AppReqVO> urlParamReqList = new ArrayList<>();

            List<AppReqEntity> reqList = entity.getAppReqList();
            if(reqList!=null && reqList.size()>0){
                for(AppReqEntity item : reqList){
                    if("header".equals(item.getType())){
                        headerReqList.add(BeanMapper.map(item, AppReqVO.class));
                    }else if("body".equals(item.getType())){
                        bodyReqList.add(BeanMapper.map(item, AppReqVO.class));
                    }else if("urlParam".equals(item.getType())){
                        urlParamReqList.add(BeanMapper.map(item, AppReqVO.class));
                    }
                }
            }
            vo.setHeaderReqList(headerReqList);

            List<AppReqVO> detailVOS = createTreeData1(bodyReqList);
            vo.setBodyReqList(detailVOS);

            vo.setUrlParamReqList(urlParamReqList);

            List<AppRespVO> appRespList = createTreeData2(vo.getAppRespList());
            vo.setAppRespList(appRespList);
        }

        return vo;
    }

    @Override
    public AppInterfaceVO queryById(Long id) {
        AppInterfaceVO vo = this.queryDetail(id);

        QueryWrapper<WaitApplyEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("user_id", InvocationInfoProxy.getUserid());
        wrapper.eq("interface_id", id);
        List<WaitApplyEntity> waitList = waitApplyService.list(wrapper);
        if(waitList!=null && waitList.size()>0){
            vo.setWait(true);
        }
        AppEntity app = appService.selectById(vo.getAppId());
        if(app!=null && StringUtils.isNotBlank(app.getAppIconSrc())){
            String appIconSrc = environmentTools.getBaseHost() +app.getAppIconSrc();
            vo.setAppIconSrc(appIconSrc);
        }
        return vo;
    }

    @Override
    public void testSql(Long id){
        AppInterfaceEntity appInterface = this.selectById(id);
        AppResourceConnectEntity uniqueBean = appResourceConnectService.getById(appInterface.getSqlDataSourceId());

        Map<String, String> dataSourceMap = new HashMap<>();
        dataSourceMap.put("driver", "com.mysql.jdbc.Driver");
        dataSourceMap.put("jdbcurl", "jdbc:mysql://"+uniqueBean.getDatabaseHost()+":"+uniqueBean.getDatabasePort()+"/"+uniqueBean.getDatabaseName()+"?useUnicode=true&characterEncoding=utf-8&autoReconnect=true&failOverReadOnly=false&useSSL=false");
        dataSourceMap.put("username", uniqueBean.getDatabaseUser());
        dataSourceMap.put("password", uniqueBean.getDatabasePassword());
        dataSourceMap.put("pooled", "false");

        JSONObject params = new JSONObject();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("parentId", 1286210139836182530l);
        String sql = appInterface.getSqlData();
        List<String> paramList = this.getVariables(sql);
        Map<String, Object> paramMap = new HashMap<>();
        if(paramList!=null && paramList.size()>0){
            for (String p : paramList) {
                sql = sql.replace("${"+p+"}", params.get(p).toString());
            }
        }

        Map<String, String> query = new HashMap<>();
        query.put("sql", sql);

        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            List<JSONObject> data = jdbcDataProvider.getDataList();
            System.out.println(data);
//            boolean connectionFlag = jdbcDataProvider.testConnection();

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    public List<String> getVariables(String str) {
        List<String> variables = new ArrayList<>();
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    @Override
    public IPage<AppInterfaceVO> queryMarketInterfaceList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("interfaceName");
        fuzzyFields.add("interfaceAddress");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<AppInterfaceEntity> page = this.queryPage(param,false);
        IPage<AppInterfaceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppInterfaceVO.class));
        if(pageData.getRecords()!=null && pageData.getRecords().size()>0){
            //获取
            QueryWrapper<WaitApplyEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("user_id", InvocationInfoProxy.getUserid());
            List<WaitApplyEntity> waitList = waitApplyService.list(wrapper);
            Map<Long, WaitApplyEntity> mapWait = new HashMap<>();
            if(waitList!=null && waitList.size()>0){
                for (WaitApplyEntity cefocAsipWaitApplyEntity : waitList) {
                    mapWait.put(cefocAsipWaitApplyEntity.getInterfaceId(), cefocAsipWaitApplyEntity);
                }
            }
            List<Long> appIds = new ArrayList<>();
            for (AppInterfaceVO record : pageData.getRecords()) {
                if(!appIds.contains(record.getAppId())){
                    appIds.add(record.getAppId());
                }
            }
            List<AppEntity> appList = (List<AppEntity>) appService.listByIds(appIds);
            Map<Long, AppEntity> mapApp = new HashMap<>();
            if(appList!=null && appList.size()>0){
                for (AppEntity app : appList) {
                    mapApp.put(app.getId(), app);
                }
            }
            for (AppInterfaceVO record : pageData.getRecords()) {
                if(mapWait.get(record.getId())!=null){
                    record.setWait(true);
                }else{
                    record.setWait(false);
                }
                if(mapApp.get(record.getAppId())!=null && StringUtils.isNotBlank(mapApp.get(record.getAppId()).getAppIconSrc())){
                    String appIconSrc = environmentTools.getBaseHost() + mapApp.get(record.getAppId()).getAppIconSrc();
                    record.setAppIconSrc(appIconSrc);
                }
            }
        }
        return pageData;
    }


}
