package com.ejianc.business.cefoc.asip.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceConnectEntity;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IAppResourceConnectService;
import com.ejianc.business.cefoc.asip.utils.JdbcDataProvider;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DESUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cefoc.asip.mapper.ApplyMapper;
import com.ejianc.business.cefoc.asip.bean.ApplyEntity;
import com.ejianc.business.cefoc.asip.service.IApplyService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 申请表
 * 
 * @author generator
 * 
 */
@Service("applyService")
public class ApplyServiceImpl extends BaseServiceImpl<ApplyMapper, ApplyEntity> implements IApplyService {

    @Autowired
    private IAppResourceConnectService appResourceConnectService;
    @Autowired
    private IAppInterfaceService appInterfaceService;

    private void testSql(Long id){
        AppInterfaceEntity appInterface = appInterfaceService.selectById(id);
        AppResourceConnectEntity uniqueBean = appResourceConnectService.getById(appInterface.getSqlDataSourceId());

        Map<String, String> dataSourceMap = new HashMap<>();
        dataSourceMap.put("driver", "com.mysql.jdbc.Driver");
        dataSourceMap.put("jdbcurl", "jdbc:mysql://"+uniqueBean.getDatabaseHost()+":"+uniqueBean.getDatabasePort()+"/"+uniqueBean.getDatabaseType()+"?useUnicode=true&characterEncoding=utf-8&autoReconnect=true&failOverReadOnly=false&useSSL=false");
        dataSourceMap.put("username", uniqueBean.getDatabaseUser());
        dataSourceMap.put("password", uniqueBean.getDatabasePassword());
        dataSourceMap.put("pooled", "false");

        JSONObject params = new JSONObject();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        String sql = appInterface.getSqlData();
        List<String> paramList = this.getVariables(sql);
        Map<String, Object> paramMap = new HashMap<>();
        if(paramList!=null && paramList.size()>0){
            paramList.forEach(p -> {
                sql.replaceAll("\\${"+p+"}", (String) params.get(p));
            });
        }

        Map<String, String> query = new HashMap<>();
        query.put("sql", sql);

        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            List<JSONObject> data = jdbcDataProvider.getDataList();
//            boolean connectionFlag = jdbcDataProvider.testConnection();

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    public List<String> getVariables(String str) {
        List<String> variables = new ArrayList<>();
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }
}
