/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.bean.AppResourceConnectEntity;
import com.ejianc.business.cefoc.asip.service.IAppAuthService;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IAppResourceConnectService;
import com.ejianc.business.cefoc.asip.service.IInterfaceHandlerService;
import com.ejianc.business.cefoc.asip.service.WebServiceClientUtil;
import com.ejianc.business.cefoc.asip.utils.JdbcDataProvider;
import com.ejianc.business.cefoc.asip.vo.AppAuthReqParamVO;
import com.ejianc.business.cefoc.asip.vo.AppAuthVO;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AppReqVO;
import com.ejianc.business.cefoc.asip.vo.AppRespVO;
import com.ejianc.business.cefoc.asip.vo.WsdlConfig;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service(value="interfaceHandlerService")
public class InterfaceHandlerService
implements IInterfaceHandlerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAppAuthService appAuthService;
    @Autowired
    private IAppInterfaceService appInterfaceService;
    @Autowired
    private IAppResourceConnectService appResourceConnectService;

    @Override
    public CommonResponse<Object> httpHandler(JSONObject params, AppInterfaceVO appInterface, String interfaceCode, HttpServletRequest request) {
        if (appInterface == null) {
            this.logger.error("\u83b7\u53d6\u63a5\u53e3\u4fe1\u606f\u5931\u8d25\uff01apiId = {}", (Object)request.getHeader("apiId"));
            return CommonResponse.error((String)"\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01");
        }
        if (!appInterface.getInterfaceIdentification().equals(interfaceCode)) {
            this.logger.error("\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01appInterface.getInterfaceIdentification = {} --- interfaceCode={}", (Object)appInterface.getInterfaceIdentification(), (Object)interfaceCode);
            return CommonResponse.error((String)"\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01");
        }
        AppAuthVO appAuth = this.appAuthService.queryDetailByAppId(appInterface.getAppId(), "http");
        if (appAuth == null) {
            this.logger.error("\u83b7\u53d6\u63a5\u53e3\u6743\u9650\u4fe1\u606f\u5931\u8d25\uff01appId = {}", (Object)appInterface.getAppId());
            return CommonResponse.error((String)"\u83b7\u53d6\u63a5\u53e3\u6743\u9650\u4fe1\u606f\u5931\u8d25\uff01");
        }
        int connectTimeout = 20000;
        int readTimeout = 20000;
        if (StringUtils.isNotEmpty((CharSequence)request.getHeader("httpApiConnTimeOut"))) {
            connectTimeout = Integer.parseInt(request.getHeader("httpApiConnTimeOut"));
            this.logger.info("\u5ba2\u6237\u81ea\u5b9a\u4e49httpApiConnTimeOut = {}  appInterface={}", (Object)connectTimeout, (Object)JSONObject.toJSONString((Object)appInterface));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getHeader("httpApiReadTimeOut"))) {
            readTimeout = Integer.parseInt(request.getHeader("httpApiReadTimeOut"));
            this.logger.info("\u5ba2\u6237\u81ea\u5b9a\u4e49httpApiReadTimeOut = {}  appInterface={}", (Object)readTimeout, (Object)JSONObject.toJSONString((Object)appInterface));
        }
        String url = appInterface.getHttpAddress();
        HashMap<String, String> headers = new HashMap<String, String>();
        if ("none".equals(appAuth.getAuthType()) || "simple".equals(appAuth.getAuthType())) {
            url = this.getUrlParam(new JSONObject(), url, appAuth.getUrlParamSetReqList(), appInterface.getUrlParamReqList(), params, request);
            this.getUrlHeaders(new JSONObject(), appAuth.getHeaderSetReqList(), appInterface.getHeaderReqList(), headers, request);
            if (HttpMethod.GET.name().equals(appInterface.getHttpMode())) {
                try {
                    String result = HttpTookit.get((String)url, null, headers, (int)connectTimeout, (int)readTimeout);
                    try {
                        JSONObject jsonObject = JSONObject.parseObject((String)result);
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)jsonObject);
                    }
                    catch (Exception jsonObject) {
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)result);
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff01", (Throwable)e);
                    return CommonResponse.error((String)e.getMessage());
                }
            }
            if (HttpMethod.POST.name().equals(appInterface.getHttpMode())) {
                try {
                    String result = null;
                    if (StringUtils.isEmpty((CharSequence)appInterface.getHttpRequestBodyFormat()) || "none".equals(appInterface.getHttpRequestBodyFormat())) {
                        result = HttpTookit.postByJson((String)url, null, headers, (Integer)connectTimeout, (Integer)readTimeout);
                    } else if ("json".equals(appInterface.getHttpRequestBodyFormat())) {
                        params = this.getUrlBody(new JSONObject(), appAuth.getBodySetReqList(), appInterface.getBodyReqList(), params);
                        result = HttpTookit.postByJson((String)url, (String)params.toJSONString(), headers, (Integer)connectTimeout, (Integer)readTimeout);
                    } else if ("form".equals(appInterface.getHttpRequestBodyFormat())) {
                        Map<String, String> map = this.getUrlForm(new JSONObject(), appAuth.getBodySetReqList(), appInterface.getBodyReqList(), params);
                        result = HttpTookit.postForm((String)url, map, headers, (String)"application/x-www-form-urlencoded", (Integer)connectTimeout, (Integer)readTimeout);
                    }
                    try {
                        JSONObject jsonObject = JSONObject.parseObject((String)result);
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)jsonObject);
                    }
                    catch (Exception jsonObject) {
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)result);
                    }
                }
                catch (Exception e) {
                    return CommonResponse.error((String)e.getMessage());
                }
            }
        } else if ("token".equals(appAuth.getAuthType())) {
            CommonResponse<JSONObject> authResponse = this.getAuthResult(appAuth, true);
            if (!authResponse.isSuccess()) {
                this.logger.error("\u8c03\u7528\u9274\u6743\u63a5\u53e3\u5931\u8d25\uff01{}", (Object)authResponse.getMsg());
                return CommonResponse.error((String)"\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff01");
            }
            url = this.getUrlParam((JSONObject)authResponse.getData(), url, appAuth.getUrlParamSetReqList(), appInterface.getUrlParamReqList(), params, request);
            this.getUrlHeaders((JSONObject)authResponse.getData(), appAuth.getHeaderSetReqList(), appInterface.getHeaderReqList(), headers, request);
            if (HttpMethod.GET.name().equals(appInterface.getHttpMode())) {
                try {
                    String result = HttpTookit.get((String)url, null, headers, (int)connectTimeout, (int)readTimeout);
                    try {
                        JSONObject jsonObject = JSONObject.parseObject((String)result);
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)jsonObject);
                    }
                    catch (Exception jsonObject) {
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)result);
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff01", (Throwable)e);
                    return CommonResponse.error((String)e.getMessage());
                }
            }
            if (HttpMethod.POST.name().equals(appInterface.getHttpMode())) {
                try {
                    if (StringUtils.isEmpty((CharSequence)appInterface.getHttpRequestBodyFormat())) {
                        return CommonResponse.error((String)"\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff01\u672a\u8bbe\u7f6e\u8bf7\u6c42\u4f53\u7c7b\u578b\uff01");
                    }
                    String result = null;
                    if ("none".equals(appInterface.getHttpRequestBodyFormat())) {
                        result = HttpTookit.postByJson((String)url, null, headers, (Integer)connectTimeout, (Integer)readTimeout);
                    } else if ("json".equals(appInterface.getHttpRequestBodyFormat())) {
                        params = this.getUrlBody((JSONObject)authResponse.getData(), appAuth.getBodySetReqList(), appInterface.getBodyReqList(), params);
                        result = HttpTookit.postByJson((String)url, (String)params.toJSONString(), headers, (Integer)connectTimeout, (Integer)readTimeout);
                    } else if ("form".equals(appInterface.getHttpRequestBodyFormat())) {
                        Map<String, String> map = this.getUrlForm((JSONObject)authResponse.getData(), appAuth.getBodySetReqList(), appInterface.getBodyReqList(), params);
                        result = HttpTookit.postForm((String)url, map, headers, (String)"application/x-www-form-urlencoded", (Integer)connectTimeout, (Integer)readTimeout);
                    }
                    try {
                        JSONObject jsonObject = JSONObject.parseObject((String)result);
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)jsonObject);
                    }
                    catch (Exception exception) {
                        return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)result);
                    }
                }
                catch (Exception e) {
                    return CommonResponse.error((String)e.getMessage());
                }
            }
        }
        return CommonResponse.error((String)"\u8c03\u7528\u5931\u8d25!\u672a\u77e5\u9519\u8bef\uff01");
    }

    @Override
    public CommonResponse<Object> wsHandler(Map<String, Object> params, AppInterfaceVO appInterface, String interfaceCode, HttpServletRequest request) {
        if (appInterface == null) {
            this.logger.error("\u83b7\u53d6\u63a5\u53e3\u4fe1\u606f\u5931\u8d25\uff01apiId = {}", (Object)request.getHeader("apiId"));
            return CommonResponse.error((String)"\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01");
        }
        if (!appInterface.getInterfaceIdentification().equals(interfaceCode)) {
            this.logger.error("\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01appInterface.getInterfaceIdentification = {} --- interfaceCode={}", (Object)appInterface.getInterfaceIdentification(), (Object)interfaceCode);
            return CommonResponse.error((String)"\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01");
        }
        AppAuthVO appAuth = this.appAuthService.queryDetailByAppId(appInterface.getAppId(), "webService");
        if (appAuth == null) {
            this.logger.error("\u83b7\u53d6\u63a5\u53e3\u6743\u9650\u4fe1\u606f\u5931\u8d25\uff01appId = {}", (Object)appInterface.getAppId());
            return CommonResponse.error((String)"\u83b7\u53d6\u63a5\u53e3\u6743\u9650\u4fe1\u606f\u5931\u8d25\uff01");
        }
        WsdlConfig config = new WsdlConfig();
        config.setWsdlUrl(appInterface.getWebWsdlAddress());
        config.setNamespace(appInterface.getWebAddress());
        config.setServiceName(appInterface.getWebService());
        config.setPortName(appInterface.getWebPort());
        config.setOperationName(appInterface.getWebOperation());
        try {
            String result = WebServiceClientUtil.callWebService(config, params);
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)jsonObject);
            }
            catch (Exception exception) {
                return CommonResponse.success((String)"\u8c03\u7528\u6210\u529f", (Object)result);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528WebService\u5931\u8d25\uff01", (Throwable)e);
            return CommonResponse.error((String)e.getMessage());
        }
    }

    @Override
    public CommonResponse<Object> sqlHandler(JSONObject params, AppInterfaceVO appInterface, String interfaceCode, HttpServletRequest request) {
        if (appInterface == null) {
            this.logger.error("\u83b7\u53d6\u63a5\u53e3\u4fe1\u606f\u5931\u8d25\uff01apiId = {}", (Object)request.getHeader("apiId"));
            return CommonResponse.error((String)"\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01");
        }
        if (!appInterface.getInterfaceIdentification().equals(interfaceCode)) {
            this.logger.error("\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01appInterface.getInterfaceIdentification = {} --- interfaceCode={}", (Object)appInterface.getInterfaceIdentification(), (Object)interfaceCode);
            return CommonResponse.error((String)"\u63a5\u53e3\u5730\u5740\u975e\u6cd5\uff01");
        }
        AppResourceConnectEntity uniqueBean = (AppResourceConnectEntity)((Object)this.appResourceConnectService.getById(appInterface.getSqlDataSourceId()));
        String sql = appInterface.getSqlData();
        List<String> paramList = this.getVariables(sql);
        HashMap paramMap = new HashMap();
        if (paramList != null && paramList.size() > 0) {
            for (String p : paramList) {
                sql = sql.replace("${" + p + "}", params.get((Object)p).toString());
            }
        }
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("sql", sql);
        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        Map<String, String> dataSourceMap = jdbcDataProvider.bulidDataSource(uniqueBean);
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            if ("select".equals(appInterface.getSqlType())) {
                List<JSONObject> data = jdbcDataProvider.getDataList();
                List<Object> result = new ArrayList();
                if (data != null && data.size() > 0) {
                    List appRespList = appInterface.getAppRespList();
                    HashMap<String, String> columnMap = new HashMap<String, String>();
                    if (appRespList != null && appRespList.size() > 0) {
                        for (AppRespVO appRespVO : appRespList) {
                            columnMap.put(appRespVO.getColumnKey(), appRespVO.getParamName());
                        }
                        for (JSONObject item : data) {
                            JSONObject ob = new JSONObject();
                            for (String key : item.keySet()) {
                                if (columnMap.get(key) == null) continue;
                                ob.put((String)columnMap.get(key), item.get((Object)key));
                            }
                            result.add(ob);
                        }
                    } else {
                        result = data;
                    }
                }
                return CommonResponse.success(result);
            }
            Integer re = jdbcDataProvider.executeUpdate();
            return CommonResponse.success((Object)re);
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2sql\u6570\u636e\u5931\u8d25----:{}", (Object)e.getMessage());
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u5931\u8d25");
        }
    }

    private void getUrlHeaders(JSONObject authResult, List<AppAuthReqParamVO> headerReqList, List<AppReqVO> urlHeaderReqList, Map<String, String> headers, HttpServletRequest request) {
        String paramValue;
        if (ListUtil.isNotEmpty(headerReqList)) {
            for (AppAuthReqParamVO appAuthReqParamVO : headerReqList) {
                String string = paramValue = request == null ? null : request.getHeader(appAuthReqParamVO.getParamName());
                if (StringUtils.isEmpty((CharSequence)paramValue) && "formula".equals(appAuthReqParamVO.getParamFormat())) {
                    String[] keys = appAuthReqParamVO.getParamValue().split("\\.");
                    for (int i = 1; i < keys.length; ++i) {
                        if (i == keys.length - 1) {
                            paramValue = authResult.getString(keys[i]);
                            continue;
                        }
                        authResult = authResult.getJSONObject(keys[i]);
                    }
                }
                headers.put(appAuthReqParamVO.getParamName(), paramValue);
            }
        }
        if (ListUtil.isNotEmpty(urlHeaderReqList)) {
            for (AppReqVO appReqVO : urlHeaderReqList) {
                String string = paramValue = request == null ? null : request.getHeader(appReqVO.getParamName());
                if (request == null) {
                    headers.put(appReqVO.getParamName(), appReqVO.getParamValue());
                    continue;
                }
                headers.put(appReqVO.getParamName(), paramValue);
            }
        }
    }

    @Override
    public CommonResponse<JSONObject> getAuthResult(AppAuthVO appAuth, Boolean checkFlag) {
        String url = appAuth.getAddress();
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            url = this.getUrlParam(new JSONObject(), url, null, appAuth.getUrlParamReqList(), new JSONObject(), null);
            this.getUrlHeaders(new JSONObject(), null, appAuth.getHeaderReqList(), headers, null);
            JSONObject params = new JSONObject();
            if (HttpMethod.GET.name().equals(appAuth.getMode())) {
                try {
                    String result = HttpTookit.get((String)url, null, headers);
                    if (checkFlag.booleanValue()) {
                        this.checkAuthResult(appAuth, result);
                    }
                    JSONObject authResult = JSONObject.parseObject((String)result);
                    return CommonResponse.success((String)"\u8c03\u7528\u9274\u6743\u6210\u529f", (Object)authResult);
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u9274\u6743\u63a5\u53e3\u5931\u8d25\uff01" + JSONObject.toJSONString((Object)appAuth), (Throwable)e);
                    return CommonResponse.error((String)("\u8c03\u7528\u9274\u6743\u63a5\u53e3\u5931\u8d25\uff01" + JSONObject.toJSONString((Object)appAuth) + " err = " + e.getMessage()));
                }
            }
            try {
                String result = null;
                if (StringUtils.isEmpty((CharSequence)appAuth.getRequestBodyFormat()) || "none".equals(appAuth.getRequestBodyFormat())) {
                    result = HttpTookit.postByJson((String)url, null, headers, (Integer)20000, (Integer)20000);
                    if (checkFlag.booleanValue()) {
                        this.checkAuthResult(appAuth, result);
                    }
                    JSONObject authResult = JSONObject.parseObject((String)result);
                    return CommonResponse.success((String)"\u8c03\u7528\u9274\u6743\u6210\u529f", (Object)authResult);
                }
                if ("json".equals(appAuth.getRequestBodyFormat())) {
                    if (ListUtil.isNotEmpty((List)appAuth.getBodyReqList())) {
                        for (AppReqVO appReqVO : appAuth.getBodyReqList()) {
                            if (!ListUtil.isNotEmpty((List)appReqVO.getChildren())) continue;
                            for (AppReqVO ch : appReqVO.getChildren()) {
                                params.put(ch.getParamName(), (Object)ch.getParamValue());
                            }
                        }
                    }
                    result = HttpTookit.postByJson((String)url, (String)params.toJSONString(), headers, (Integer)20000, (Integer)20000);
                    if (checkFlag.booleanValue()) {
                        this.checkAuthResult(appAuth, result);
                    }
                    JSONObject authResult = JSONObject.parseObject((String)result);
                    return CommonResponse.success((String)"\u8c03\u7528\u9274\u6743\u6210\u529f", (Object)authResult);
                }
                if ("form".equals(appAuth.getRequestBodyFormat())) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (ListUtil.isNotEmpty((List)appAuth.getBodyReqList())) {
                        for (AppReqVO appReqVO : appAuth.getBodyReqList()) {
                            map.put(appReqVO.getParamName(), appReqVO.getParamValue());
                        }
                    }
                    result = HttpTookit.postForm((String)url, map, headers, null, (Integer)20000, (Integer)20000);
                    if (checkFlag.booleanValue()) {
                        this.checkAuthResult(appAuth, result);
                    }
                    JSONObject authResult = JSONObject.parseObject((String)result);
                    return CommonResponse.success((String)"\u8c03\u7528\u9274\u6743\u6210\u529f", (Object)authResult);
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u9274\u6743\u63a5\u53e3\u5931\u8d25\uff01" + JSONObject.toJSONString((Object)appAuth), (Throwable)e);
                return CommonResponse.error((String)("\u8c03\u7528\u9274\u6743\u63a5\u53e3\u5931\u8d25\uff01" + JSONObject.toJSONString((Object)appAuth) + " err = " + e.getMessage()));
            }
        }
        catch (Exception e) {
            return CommonResponse.error((String)e.getMessage());
        }
        return CommonResponse.error((String)"\u8c03\u7528\u9274\u6743\u63a5\u53e3\u5931\u8d25\uff01\u672a\u77e5\u9519\u8bef");
    }

    private void checkAuthResult(AppAuthVO appAuth, String result) throws Exception {
        int i;
        JSONObject jsonObject;
        String[] keys;
        if (ListUtil.isNotEmpty((List)appAuth.getHeaderSetReqList())) {
            for (AppAuthReqParamVO appAuthReqParamVO : appAuth.getHeaderSetReqList()) {
                if (!"formula".equals(appAuthReqParamVO.getParamFormat())) continue;
                keys = appAuthReqParamVO.getParamValue().split("\\.");
                jsonObject = JSONObject.parseObject((String)result);
                for (i = 1; i < keys.length; ++i) {
                    if (i == keys.length - 1) {
                        jsonObject.getString(keys[i]);
                        continue;
                    }
                    jsonObject = jsonObject.getJSONObject(keys[i]);
                }
            }
        }
        if (ListUtil.isNotEmpty((List)appAuth.getBodySetReqList())) {
            for (AppAuthReqParamVO appAuthReqParamVO : appAuth.getBodySetReqList()) {
                if (!"formula".equals(appAuthReqParamVO.getParamFormat())) continue;
                keys = appAuthReqParamVO.getParamValue().split("\\.");
                jsonObject = JSONObject.parseObject((String)result);
                for (i = 1; i < keys.length; ++i) {
                    if (i == keys.length - 1) {
                        jsonObject.getString(keys[i]);
                        continue;
                    }
                    jsonObject = jsonObject.getJSONObject(keys[i]);
                }
            }
        }
        if (ListUtil.isNotEmpty((List)appAuth.getUrlParamSetReqList())) {
            for (AppAuthReqParamVO appAuthReqParamVO : appAuth.getUrlParamSetReqList()) {
                if (!"formula".equals(appAuthReqParamVO.getParamFormat())) continue;
                keys = appAuthReqParamVO.getParamValue().split("\\.");
                jsonObject = JSONObject.parseObject((String)result);
                for (i = 1; i < keys.length; ++i) {
                    if (i == keys.length - 1) {
                        jsonObject.getString(keys[i]);
                        continue;
                    }
                    jsonObject = jsonObject.getJSONObject(keys[i]);
                }
            }
        }
    }

    private JSONObject getUrlBody(JSONObject authResult, List<AppAuthReqParamVO> bodyReqList, List<AppReqVO> urlBodyReqList, JSONObject body) {
        JSONObject newBody = new JSONObject();
        JSONObject formatBody = new JSONObject();
        List children = urlBodyReqList.get(0).getChildren();
        for (AppReqVO childrenReq : children) {
            formatBody.put(childrenReq.getParamName(), body.get((Object)childrenReq.getParamName()));
            newBody.put(childrenReq.getParamName(), body.get((Object)childrenReq.getParamName()));
        }
        newBody.put(urlBodyReqList.get(0).getParamName(), (Object)formatBody);
        if (ListUtil.isNotEmpty(bodyReqList)) {
            for (AppAuthReqParamVO appReqVO : bodyReqList) {
                String paramValue = appReqVO.getParamValue();
                if ("formula".equals(appReqVO.getParamFormat())) {
                    String[] keys = appReqVO.getParamValue().split("\\.");
                    for (int i = 1; i < keys.length; ++i) {
                        if (i == keys.length - 1) {
                            paramValue = authResult.getString(keys[i]);
                            continue;
                        }
                        authResult = authResult.getJSONObject(keys[i]);
                    }
                }
                newBody.put(appReqVO.getParamName(), (Object)paramValue);
            }
        }
        return newBody;
    }

    private Map<String, String> getUrlForm(JSONObject authResult, List<AppAuthReqParamVO> bodyReqList, List<AppReqVO> urlBodyReqList, JSONObject body) {
        HashMap<String, String> newBody = new HashMap<String, String>();
        if (ListUtil.isNotEmpty(urlBodyReqList)) {
            for (AppReqVO childrenReq : urlBodyReqList) {
                newBody.put(childrenReq.getParamName(), body.getString(childrenReq.getParamName()));
            }
        }
        if (ListUtil.isNotEmpty(bodyReqList)) {
            for (AppAuthReqParamVO appReqVO : bodyReqList) {
                String paramValue = appReqVO.getParamValue();
                if ("formula".equals(appReqVO.getParamFormat())) {
                    String[] keys = appReqVO.getParamValue().split("\\.");
                    for (int i = 1; i < keys.length; ++i) {
                        if (i == keys.length - 1) {
                            paramValue = authResult.getString(keys[i]);
                            continue;
                        }
                        authResult = authResult.getJSONObject(keys[i]);
                    }
                }
                newBody.put(appReqVO.getParamName(), paramValue);
            }
        }
        return newBody;
    }

    private String getUrlParam(JSONObject authResult, String url, List<AppAuthReqParamVO> paramReqList, List<AppReqVO> urlParamReqList, JSONObject params, HttpServletRequest request) {
        String paramValue;
        String urlLeft = url.contains("?") ? url.split("\\?")[0] : url;
        StringBuilder urlRight = new StringBuilder(url.contains("?") ? url.split("\\?")[1] : "");
        if (ListUtil.isNotEmpty(paramReqList)) {
            for (AppAuthReqParamVO appAuthReqParamVO : paramReqList) {
                paramValue = appAuthReqParamVO.getParamValue();
                if ("formula".equals(appAuthReqParamVO.getParamFormat())) {
                    String[] keys = appAuthReqParamVO.getParamValue().split("\\.");
                    for (int i = 1; i < keys.length; ++i) {
                        if (i == keys.length - 1) {
                            paramValue = authResult.getString(keys[i]);
                            continue;
                        }
                        authResult = authResult.getJSONObject(keys[i]);
                    }
                }
                if (urlRight.toString().contains(appAuthReqParamVO.getParamName())) continue;
                if (urlRight.length() > 0) {
                    urlRight.append("&");
                }
                urlRight.append(appAuthReqParamVO.getParamName()).append("=").append(paramValue);
            }
        }
        if (ListUtil.isNotEmpty(urlParamReqList)) {
            for (AppReqVO appReqVO : urlParamReqList) {
                if (request == null) {
                    if (urlRight.toString().contains(appReqVO.getParamName())) continue;
                    if (urlRight.length() > 0) {
                        urlRight.append("&");
                    }
                    urlRight.append(appReqVO.getParamName()).append("=").append(appReqVO.getParamValue());
                    continue;
                }
                paramValue = request.getParameter(appReqVO.getParamName());
                if (StringUtils.isEmpty((CharSequence)paramValue)) {
                    paramValue = params.getString(appReqVO.getParamName());
                }
                if (urlRight.toString().contains(appReqVO.getParamName())) continue;
                if (urlRight.length() > 0) {
                    urlRight.append("&");
                }
                urlRight.append(appReqVO.getParamName()).append("=").append(paramValue);
            }
        }
        if (urlRight.length() == 0) {
            return url;
        }
        return urlLeft + "?" + urlRight;
    }

    public List<String> getVariables(String str) {
        ArrayList<String> variables = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }
}

