package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.ApplyInterfaceEntity;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.WebServiceClientUtil;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.ApplyVO;
import com.ejianc.business.cefoc.asip.vo.WsdlConfig;
import com.ejianc.business.cefoc.asip.vo.ApplyInterfaceVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 应用-接口
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appInterface")
public class AppInterfaceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppInterfaceService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppInterfaceVO> saveOrUpdate(@RequestBody AppInterfaceVO saveOrUpdateVO) {
        AppInterfaceVO vo =  service.saveData(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppInterfaceVO> queryDetail(Long id) {
        AppInterfaceVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppInterfaceVO> queryById(Long id) {
        AppInterfaceVO vo = service.queryById(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AppInterfaceVO> vos) {
        service.removeByIds(vos.stream().map(AppInterfaceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppInterfaceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AppInterfaceEntity> page = service.queryPage(param,false);
        IPage<AppInterfaceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppInterfaceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryMarketInterfaceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppInterfaceVO>> queryMarketInterfaceList(@RequestBody QueryParam param) {
        IPage<AppInterfaceVO> pageData = service.queryMarketInterfaceList(param);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAppInterfaceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppInterfaceVO>> refAppInterfaceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
        String condition,String searchObject, String searchText, @RequestParam(required=false) String relyCondition) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("appId")!=null){
                param.getParams().put("appId", new Parameter(QueryParam.EQ, _con.get("appId")));
            }
        }
        if(StringUtils.isNotBlank(relyCondition)){
            Long appId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("appId", new Parameter(QueryParam.EQ, appId));
        }

        IPage<AppInterfaceEntity> page = service.queryPage(param,false);
        IPage<AppInterfaceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppInterfaceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     /**
     * @Description 解析WSDL
     * @Return void
     */
     @RequestMapping(value = "/parseWsdl", method = RequestMethod.GET)
     @ResponseBody
     public CommonResponse<WsdlConfig> parseWsdl(String webWsdlAddress) {
         WsdlConfig config = null;
         try {
             config = WebServiceClientUtil.parseWsdl(webWsdlAddress);
         } catch (Exception e) {
             return CommonResponse.error("解析失败！"+e.getMessage());
         }
         return CommonResponse.success("解析成功！",config);
     }

    @RequestMapping(value = "/testSql", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> testSql(Long id) {
        service.testSql(id);
        return CommonResponse.success("查询详情数据成功！");
    }
}
