/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppCategoryEntity;
import com.ejianc.business.cefoc.asip.service.IAppCategoryService;
import com.ejianc.business.cefoc.asip.vo.AppCategoryVO;
import com.ejianc.business.cefoc.asip.vo.PublishDataVO;
import com.ejianc.business.cefoc.asip.vo.PublishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"appCategory"})
public class AppCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAppCategoryService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AppCategoryVO> saveOrUpdate(@RequestBody AppCategoryVO saveOrUpdateVO) {
        AppCategoryEntity entity = (AppCategoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppCategoryEntity.class));
        if (entity.getId() != null) {
            entity = (AppCategoryEntity)((Object)this.service.selectById(entity.getId()));
            entity.setName(saveOrUpdateVO.getName());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
        this.service.saveOrUpdate((Object)entity, false);
        AppCategoryVO vo = (AppCategoryVO)BeanMapper.map((Object)((Object)entity), AppCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AppCategoryVO> queryDetail(Long id) {
        AppCategoryEntity entity = (AppCategoryEntity)((Object)this.service.selectById(id));
        AppCategoryVO vo = (AppCategoryVO)BeanMapper.map((Object)((Object)entity), AppCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AppCategoryVO> vos) {
        this.service.removeByIds(vos.stream().map(AppCategoryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AppCategoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AppCategoryVO>> queryAllList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List data = this.service.queryList(param, false);
        List list = new ArrayList();
        if (data != null && data.size() > 0) {
            list = BeanMapper.mapList((Iterable)data, AppCategoryVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CefocAsipAppCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCefocAsipAppCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AppCategoryVO>> refCefocAsipAppCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String scope = publishVO.getScope();
            if (StringUtils.isBlank((CharSequence)scope)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            List appCategoryEntities = (List)this.service.listByIds(publishVO.getIdList());
            PublishDataVO publishDataVO = new PublishDataVO();
            if (appCategoryEntities != null && appCategoryEntities.size() > 0) {
                appCategoryEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            publishDataVO.setAppCategoryEntities(appCategoryEntities);
            publishDataVO.setType("appCategory");
            String url = publishVO.getTarget() + "/cefoc-asip-web/dataTransfer/transferBySql";
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = gson.toJson((Object)publishDataVO);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e3) {
            return CommonResponse.error((String)("\u53d1\u5e03\u6570\u636e\u5931\u8d25:" + e3.getMessage()));
        }
    }
}

