/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppAuthEntity;
import com.ejianc.business.cefoc.asip.bean.AppEntity;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureEntity;
import com.ejianc.business.cefoc.asip.bean.AppUserRelationEntity;
import com.ejianc.business.cefoc.asip.service.IAppAuthConfigService;
import com.ejianc.business.cefoc.asip.service.IAppAuthReqParamService;
import com.ejianc.business.cefoc.asip.service.IAppAuthService;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IAppReqService;
import com.ejianc.business.cefoc.asip.service.IAppResourceConnectService;
import com.ejianc.business.cefoc.asip.service.IAppResourceConstantService;
import com.ejianc.business.cefoc.asip.service.IAppResourceDataStructureParamService;
import com.ejianc.business.cefoc.asip.service.IAppResourceDataStructureService;
import com.ejianc.business.cefoc.asip.service.IAppResourceLogicService;
import com.ejianc.business.cefoc.asip.service.IAppRespService;
import com.ejianc.business.cefoc.asip.service.IAppService;
import com.ejianc.business.cefoc.asip.service.IAppUserRelationService;
import com.ejianc.business.cefoc.asip.vo.AppVO;
import com.ejianc.business.cefoc.asip.vo.PublishDataVO;
import com.ejianc.business.cefoc.asip.vo.PublishVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"app"})
public class AppController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_CODE = "CEDOC_ASIP_APP";
    @Autowired
    private IAppService service;
    @Autowired
    private IAppUserRelationService appUserRelationService;
    @Autowired
    private IAppAuthConfigService appAuthConfigService;
    @Autowired
    private IAppAuthReqParamService appAuthReqParamService;
    @Autowired
    private IAppAuthService appAuthService;
    @Autowired
    private IAppInterfaceService appInterfaceService;
    @Autowired
    private IAppReqService appReqService;
    @Autowired
    private IAppResourceConnectService appResourceConnectService;
    @Autowired
    private IAppResourceConstantService appResourceConstantService;
    @Autowired
    private IAppResourceDataStructureParamService appResourceDataStructureParamService;
    @Autowired
    private IAppResourceDataStructureService appResourceDataStructureService;
    @Autowired
    private IAppResourceLogicService appResourceLogicService;
    @Autowired
    private IAppRespService appRespService;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveBaseData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AppVO> saveBaseData(@RequestBody AppVO saveOrUpdateVO) {
        Object id;
        AppEntity entity = (AppEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            id = IdWorker.getId();
            entity.setId((Long)id);
            if (StringUtils.isBlank((CharSequence)entity.getAppCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setAppCode((String)billCode.getData());
            } else {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"app_code", (Object)entity.getAppCode());
                wrapper.ne((Object)"id", (Object)entity.getId());
                List list = this.service.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    throw new BusinessException("\u5e94\u7528\u6807\u8bc6\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5e94\u7528\u6807\u8bc6");
                }
            }
            AppUserRelationEntity userRelationEntity = new AppUserRelationEntity();
            userRelationEntity.setAppId((Long)id);
            userRelationEntity.setUserId(InvocationInfoProxy.getUserid());
            userRelationEntity.setType("1");
            this.appUserRelationService.saveOrUpdate((Object)userRelationEntity, false);
        } else {
            if (StringUtils.isNotBlank((CharSequence)(entity = (AppEntity)((Object)this.service.selectById(entity.getId()))).getAppIconSrc())) {
                if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getAppIconSrc())) {
                    if (!entity.getAppIconSrc().equals(saveOrUpdateVO.getAppIconSrc())) {
                        if (StringUtils.isNotBlank((CharSequence)entity.getAppIconSrc()) && entity.getAppIconSrc().contains("=") && StringUtils.isNotBlank((CharSequence)(id = entity.getAppIconSrc().split("=")[1]))) {
                            this.attachmentApi.delete((String)id);
                        }
                        if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getAppIconSrc()) && saveOrUpdateVO.getAppIconSrc().contains("=") && StringUtils.isNotBlank((CharSequence)(id = saveOrUpdateVO.getAppIconSrc().split("=")[1]))) {
                            ArrayList<Long> attachIds = new ArrayList<Long>();
                            attachIds.add(Long.parseLong((String)id));
                            this.attachmentApi.updateAttachRef(entity.getId(), attachIds);
                        }
                    }
                } else if (StringUtils.isNotBlank((CharSequence)entity.getAppIconSrc()) && entity.getAppIconSrc().contains("=") && StringUtils.isNotBlank((CharSequence)(id = entity.getAppIconSrc().split("=")[1]))) {
                    this.attachmentApi.delete((String)id);
                }
            } else if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getAppIconSrc()) && StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getAppIconSrc()) && saveOrUpdateVO.getAppIconSrc().contains("=") && StringUtils.isNotBlank((CharSequence)(id = saveOrUpdateVO.getAppIconSrc().split("=")[1]))) {
                ArrayList<Long> attachIds = new ArrayList<Long>();
                attachIds.add(Long.parseLong((String)id));
                this.attachmentApi.updateAttachRef(entity.getId(), attachIds);
            }
            entity.setAppCode(saveOrUpdateVO.getAppCode());
            entity.setAppName(saveOrUpdateVO.getAppName());
            entity.setAppIconSrc(saveOrUpdateVO.getAppIconSrc());
            entity.setRemark(saveOrUpdateVO.getRemark());
        }
        this.service.saveOrUpdate((Object)entity, false);
        AppVO vo = (AppVO)BeanMapper.map((Object)((Object)entity), AppVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AppVO> saveConfig(@RequestBody AppVO saveOrUpdateVO) {
        AppEntity entity = (AppEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppEntity.class));
        if (entity.getId() != null && entity.getId() != 0L) {
            entity = (AppEntity)((Object)this.service.selectById(entity.getId()));
            entity.setDateFormat(saveOrUpdateVO.getDateFormat());
            entity.setStringQuote(saveOrUpdateVO.getStringQuote());
            entity.setReserveNull(saveOrUpdateVO.getReserveNull());
            entity.setCaseRecognition(saveOrUpdateVO.getCaseRecognition());
        }
        this.service.saveOrUpdate((Object)entity, false);
        AppVO vo = (AppVO)BeanMapper.map((Object)((Object)entity), AppVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AppVO> queryDetail(Long id) {
        AppEntity entity = (AppEntity)((Object)this.service.selectById(id));
        AppVO vo = (AppVO)BeanMapper.map((Object)((Object)entity), AppVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/changeAppPublish"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeAppPublish(Long id, Integer publish) {
        AppEntity entity = (AppEntity)((Object)this.service.selectById(id));
        entity.setPublish(publish);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AppVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("app_name");
        fuzzyFields.add("app_code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMarketAppList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AppVO>> queryMarketAppList() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("publish", new Parameter("eq", (Object)1));
        List data = this.service.queryList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)data, AppVO.class));
    }

    @RequestMapping(value={"/referMarketAppList"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AppVO> referMarketAppList() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("publish", new Parameter("eq", (Object)1));
        List data = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)data, AppVO.class);
        return vos;
    }

    @RequestMapping(value={"/refCefocAsipAppData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AppVO>> refCefocAsipAppData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)InvocationInfoProxy.getUserid());
        List userList = this.appUserRelationService.list((Wrapper)wrapper);
        ArrayList<Long> appIds = new ArrayList<Long>();
        if (userList != null && userList.size() > 0) {
            for (AppUserRelationEntity en : userList) {
                appIds.add(en.getAppId());
            }
        }
        param.getParams().put("id", new Parameter("in", appIds));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ResponseBody
    @RequestMapping(value={"publish"})
    public CommonResponse<String> publish(@RequestBody PublishVO publishVO) {
        try {
            String targetEnv = publishVO.getTarget();
            if (StringUtils.isBlank((CharSequence)targetEnv)) {
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25:\u76ee\u6807\u73af\u5883\u57df\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            List appEntities = (List)this.service.listByIds(publishVO.getIdList());
            QueryWrapper appAuthWrapper = new QueryWrapper();
            appAuthWrapper.in((Object)"app_id", publishVO.getIdList());
            List appAuthEntities = this.appAuthService.list((Wrapper)appAuthWrapper);
            QueryWrapper appAuthConfigWrapper = new QueryWrapper();
            appAuthConfigWrapper.in((Object)"app_id", publishVO.getIdList());
            List appAuthConfigEntities = this.appAuthConfigService.list((Wrapper)appAuthConfigWrapper);
            List appAuthReqParamEntities = null;
            List appReqEntities = null;
            if (appAuthEntities != null && appAuthEntities.size() > 0) {
                ArrayList<Long> authIds = new ArrayList<Long>();
                for (AppAuthEntity appAuth : appAuthEntities) {
                    authIds.add(appAuth.getId());
                }
                QueryWrapper appAuthReqParamWrapper = new QueryWrapper();
                appAuthReqParamWrapper.in((Object)"auth_id", authIds);
                appAuthReqParamEntities = this.appAuthReqParamService.list((Wrapper)appAuthReqParamWrapper);
                QueryWrapper appReqWrapper = new QueryWrapper();
                appReqWrapper.in((Object)"req_id", authIds);
                appReqEntities = this.appReqService.list((Wrapper)appReqWrapper);
            }
            QueryWrapper appInterfaceWrapper = new QueryWrapper();
            appInterfaceWrapper.in((Object)"app_id", publishVO.getIdList());
            List appInterfaceEntities = this.appInterfaceService.list((Wrapper)appInterfaceWrapper);
            List appRespEntities = null;
            if (appInterfaceEntities != null && appInterfaceEntities.size() > 0) {
                ArrayList<Long> interfaceIds = new ArrayList<Long>();
                for (AppInterfaceEntity appInterface : appInterfaceEntities) {
                    interfaceIds.add(appInterface.getId());
                }
                QueryWrapper appRespWrapper = new QueryWrapper();
                appRespWrapper.in((Object)"req_id", interfaceIds);
                appRespEntities = this.appRespService.list((Wrapper)appRespWrapper);
                QueryWrapper appReqWrapper = new QueryWrapper();
                appReqWrapper.in((Object)"req_id", interfaceIds);
                List appReqEntities1 = this.appReqService.list((Wrapper)appReqWrapper);
                if (appReqEntities != null && appReqEntities.size() > 0 && appReqEntities1 != null && appReqEntities1.size() > 0) {
                    appReqEntities.addAll(appReqEntities1);
                }
            }
            QueryWrapper appResourceConnectWrapper = new QueryWrapper();
            appResourceConnectWrapper.in((Object)"app_id", publishVO.getIdList());
            List appResourceConnectEntities = this.appResourceConnectService.list((Wrapper)appResourceConnectWrapper);
            QueryWrapper appResourceConstantWrapper = new QueryWrapper();
            appResourceConstantWrapper.in((Object)"app_id", publishVO.getIdList());
            List appResourceConstantEntities = this.appResourceConstantService.list((Wrapper)appResourceConstantWrapper);
            QueryWrapper appResourceDataStructureWrapper = new QueryWrapper();
            appResourceDataStructureWrapper.in((Object)"app_id", publishVO.getIdList());
            List appResourceDataStructureEntities = this.appResourceDataStructureService.list((Wrapper)appResourceDataStructureWrapper);
            List appResourceDataStructureParamEntities = null;
            if (appResourceDataStructureEntities != null && appResourceDataStructureEntities.size() > 0) {
                ArrayList<Long> interfaceIds = new ArrayList<Long>();
                for (AppResourceDataStructureEntity appResourceDataStructure : appResourceDataStructureEntities) {
                    interfaceIds.add(appResourceDataStructure.getId());
                }
                QueryWrapper appResourceDataStructureParamWrapper = new QueryWrapper();
                appResourceDataStructureParamWrapper.in((Object)"data_structure_id", publishVO.getIdList());
                appResourceDataStructureParamEntities = this.appResourceDataStructureParamService.list((Wrapper)appResourceDataStructureParamWrapper);
            }
            QueryWrapper apResourceLogicWrapper = new QueryWrapper();
            apResourceLogicWrapper.in((Object)"app_id", publishVO.getIdList());
            List appResourceLogicEntities = this.appResourceLogicService.list((Wrapper)apResourceLogicWrapper);
            PublishDataVO publishDataVO = new PublishDataVO();
            if (appEntities != null && appEntities.size() > 0) {
                appEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appAuthEntities != null && appAuthEntities.size() > 0) {
                appAuthEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appAuthConfigEntities != null && appAuthConfigEntities.size() > 0) {
                appAuthConfigEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appAuthReqParamEntities != null && appAuthReqParamEntities.size() > 0) {
                appAuthReqParamEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appInterfaceEntities != null && appInterfaceEntities.size() > 0) {
                appInterfaceEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appReqEntities != null && appReqEntities.size() > 0) {
                appReqEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appRespEntities != null && appRespEntities.size() > 0) {
                appRespEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appResourceConnectEntities != null && appResourceConnectEntities.size() > 0) {
                appResourceConnectEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appResourceConstantEntities != null && appResourceConstantEntities.size() > 0) {
                appResourceConstantEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appResourceDataStructureEntities != null && appResourceDataStructureEntities.size() > 0) {
                appResourceDataStructureEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appResourceDataStructureParamEntities != null && appResourceDataStructureParamEntities.size() > 0) {
                appResourceDataStructureParamEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            if (appResourceLogicEntities != null && appResourceLogicEntities.size() > 0) {
                appResourceLogicEntities.forEach(e -> {
                    e.setCreateUserCode(null);
                    e.setCreateTime(null);
                    e.setUpdateUserCode(null);
                    e.setUpdateTime(null);
                });
            }
            publishDataVO.setAppEntities(appEntities);
            publishDataVO.setAppAuthEntities(appAuthEntities);
            publishDataVO.setAppAuthConfigEntities(appAuthConfigEntities);
            publishDataVO.setAppAuthReqParamEntities(appAuthReqParamEntities);
            publishDataVO.setAppInterfaceEntities(appInterfaceEntities);
            publishDataVO.setAppReqEntities(appReqEntities);
            publishDataVO.setAppRespEntities(appRespEntities);
            publishDataVO.setAppResourceConnectEntities(appResourceConnectEntities);
            publishDataVO.setAppResourceConstantEntities(appResourceConstantEntities);
            publishDataVO.setAppResourceDataStructureEntities(appResourceDataStructureEntities);
            publishDataVO.setAppResourceDataStructureParamEntities(appResourceDataStructureParamEntities);
            publishDataVO.setAppResourceLogicEntities(appResourceLogicEntities);
            publishDataVO.setIds(publishVO.getIdList());
            publishDataVO.setType("app");
            String url = publishVO.getTarget() + "/cefoc-asip-web/dataTransfer/transferBySql";
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String paramterStr = gson.toJson((Object)publishDataVO);
            this.logger.info("\u53d1\u5e03\u6570\u636e\u7684url\uff1a---------------" + url);
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u5e03\u6570\u636e\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                return (CommonResponse)gson.fromJson(result, CommonResponse.class);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return CommonResponse.error((String)"\u53d1\u5e03\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e3) {
            return CommonResponse.error((String)("\u53d1\u5e03\u6570\u636e\u5931\u8d25:" + e3.getMessage()));
        }
    }
}

