/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppUserRelationEntity;
import com.ejianc.business.cefoc.asip.service.IAppUserRelationService;
import com.ejianc.business.cefoc.asip.vo.AppUserRelationVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"appUserRelation"})
public class AppUserRelationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAppUserRelationService service;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveList(@RequestBody List<AppUserRelationVO> list) {
        Long appId = list.get(0).getAppId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (AppUserRelationVO vo : list) {
            userIds.add(vo.getUserId());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"app_id", (Object)appId);
        wrapper.in((Object)"user_id", userIds);
        List entitys = this.service.list((Wrapper)wrapper);
        if (entitys != null && entitys.size() > 0) {
            for (AppUserRelationEntity entity : entitys) {
                if (!userIds.contains(entity.getUserId())) continue;
                userIds.remove(entity.getUserId());
            }
        }
        ArrayList<AppUserRelationEntity> addData = new ArrayList<AppUserRelationEntity>();
        if (userIds != null && userIds.size() > 0) {
            for (Long userId : userIds) {
                AppUserRelationEntity entity = new AppUserRelationEntity();
                entity.setAppId(appId);
                entity.setUserId(userId);
                entity.setType("2");
                addData.add(entity);
            }
            this.service.saveOrUpdateBatch(addData, addData.size(), false);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AppUserRelationVO> queryDetail(Long id) {
        AppUserRelationEntity entity = (AppUserRelationEntity)((Object)this.service.selectById(id));
        AppUserRelationVO vo = (AppUserRelationVO)BeanMapper.map((Object)((Object)entity), AppUserRelationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AppUserRelationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppUserRelationVO.class));
        if (pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            String[] userIds = new String[pageData.getRecords().size()];
            for (int i = 0; i < pageData.getRecords().size(); ++i) {
                AppUserRelationVO vo = (AppUserRelationVO)pageData.getRecords().get(i);
                userIds[i] = vo.getUserId().toString();
            }
            CommonResponse userResponse = this.userApi.queryListByIds(userIds);
            if (userResponse.isSuccess() && userResponse.getData() != null && ((List)userResponse.getData()).size() > 0) {
                HashMap<Long, UserVO> userMap = new HashMap<Long, UserVO>();
                for (UserVO vo : (List)userResponse.getData()) {
                    userMap.put(vo.getId(), vo);
                }
                for (UserVO vo : pageData.getRecords()) {
                    if (userMap.get(vo.getUserId()) == null) continue;
                    vo.setUserName(((UserVO)userMap.get(vo.getUserId())).getUserName());
                    vo.setOrgName(((UserVO)userMap.get(vo.getUserId())).getOrgName());
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/isUserManager"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> isUserManager(Long appId, Long userId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"app_id", (Object)appId);
        wrapper.eq((Object)"user_id", (Object)userId);
        wrapper.eq((Object)"type", (Object)"1");
        AppUserRelationEntity manager = (AppUserRelationEntity)((Object)this.service.getOne((Wrapper)wrapper));
        if (manager != null) {
            return CommonResponse.success((Object)true);
        }
        return CommonResponse.success((Object)false);
    }

    @RequestMapping(value={"/transferManager"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> transferManager(Long appId, Long userId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"app_id", (Object)appId);
        wrapper.eq((Object)"type", (Object)"1");
        AppUserRelationEntity manager = (AppUserRelationEntity)((Object)this.service.getOne((Wrapper)wrapper));
        if (manager != null && manager.getUserId().equals(userId)) {
            throw new BusinessException("\u8be5\u7528\u6237\u5df2\u662f\u7ba1\u7406\u5458");
        }
        if (manager != null) {
            manager.setType("2");
        }
        QueryWrapper wrapper2 = new QueryWrapper();
        wrapper2.eq((Object)"app_id", (Object)appId);
        wrapper2.eq((Object)"user_id", (Object)userId);
        AppUserRelationEntity user = (AppUserRelationEntity)((Object)this.service.getOne((Wrapper)wrapper2));
        if (user != null) {
            user.setType("1");
        } else {
            user = new AppUserRelationEntity();
            user.setType("1");
            user.setAppId(appId);
            user.setUserId(userId);
        }
        ArrayList<AppUserRelationEntity> entitys = new ArrayList<AppUserRelationEntity>();
        entitys.add(manager);
        entitys.add(user);
        this.service.saveOrUpdateBatch(entitys, entitys.size(), false);
        return CommonResponse.success((String)"\u79fb\u4ea4\u7ba1\u7406\u5458\u6210\u529f\uff01");
    }
}

