/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.ApplyEntity;
import com.ejianc.business.cefoc.asip.bean.ApplyInterfaceEntity;
import com.ejianc.business.cefoc.asip.service.IApplyService;
import com.ejianc.business.cefoc.asip.service.IWaitApplyService;
import com.ejianc.business.cefoc.asip.vo.ApplyInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.ApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Base64Util;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"apply"})
public class ApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IApplyService service;
    @Autowired
    private IWaitApplyService waitApplyService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "CEDOC_ASIP_APPLY";
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO saveOrUpdateVO) {
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setBillState(0);
        } else {
            ApplyEntity old = (ApplyEntity)((Object)this.service.selectById(entity.getId()));
            entity.setTenantId(old.getTenantId());
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateTime(old.getCreateTime());
            entity.setVersion(old.getVersion());
            entity.setSyncEsFlag(old.getSyncEsFlag());
        }
        this.service.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/generateApplyForm"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> generateApplyForm(@RequestBody ApplyVO saveOrUpdateVO) {
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setBillState(0);
            entity.setState(1);
            String clientId = IdWorker.getId() + "";
            String clientSecret = Base64Util.encode((byte[])clientId.getBytes());
            entity.setClientId(clientId);
            entity.setClientSecret(clientSecret);
            for (ApplyInterfaceEntity en : entity.getApplyInterfaceList()) {
                en.setState(1);
                en.setClientId(clientId);
                en.setClientSecret(clientSecret);
            }
        } else {
            ApplyEntity old = (ApplyEntity)((Object)this.service.selectById(entity.getId()));
            entity.setTenantId(old.getTenantId());
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateTime(old.getCreateTime());
            entity.setVersion(old.getVersion());
            entity.setSyncEsFlag(old.getSyncEsFlag());
        }
        this.service.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        ArrayList<Long> waitIds = new ArrayList<Long>();
        for (ApplyInterfaceVO applyInterfaceVO : saveOrUpdateVO.getApplyInterfaceList()) {
            waitIds.add(applyInterfaceVO.getWaitId());
        }
        if (waitIds != null && waitIds.size() > 0) {
            this.waitApplyService.removeByIds(waitIds);
        }
        return CommonResponse.success((String)"\u751f\u6210\u7533\u8bf7\u5355\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
        ApplyEntity entity = (ApplyEntity)((Object)this.service.selectById(id));
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> updateState(Long id, Integer state) {
        ApplyEntity entity = (ApplyEntity)((Object)this.service.selectById(id));
        entity.setState(state);
        for (ApplyInterfaceEntity en : entity.getApplyInterfaceList()) {
            en.setState(state);
        }
        this.service.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refCefocAsipApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> refCefocAsipApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

