/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.service.IJobInfoService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.job.admin.api.IJobAdminApi;
import com.xxl.job.admin.core.model.XxlJobGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"jobGroup"})
public class JobGroupController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IJobInfoService service;
    @Autowired
    private IJobAdminApi jobAdminApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<XxlJobGroup> saveOrUpdate(@RequestBody XxlJobGroup saveOrUpdateVO) {
        saveOrUpdateVO.setAddressType(0);
        if (saveOrUpdateVO.getId() == 0) {
            CommonResponse response = this.jobAdminApi.addGroup(saveOrUpdateVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
        } else {
            CommonResponse response = this.jobAdminApi.updateGroup(saveOrUpdateVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)saveOrUpdateVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<XxlJobGroup> vos) {
        StringBuilder sb = new StringBuilder("\u5220\u9664\u6267\u884c\u5668\u5931\u8d25\uff01");
        int successCount = 0;
        for (XxlJobGroup jobGroup : vos) {
            CommonResponse response = this.jobAdminApi.removeGroup(Integer.valueOf(jobGroup.getId()));
            if (!response.isSuccess()) {
                sb.append(response.getMsg());
            }
            ++successCount;
        }
        if (successCount == vos.size()) {
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)("\u90e8\u5206\u5220\u9664\u6210\u529f\uff01" + sb));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<XxlJobGroup>> queryList(@RequestBody QueryParam param) {
        CommonResponse response = this.jobAdminApi.queryGroupList();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u67e5\u8be2\u6267\u884c\u5668\u5217\u8868\u5931\u8d25\uff01" + response.getMsg()));
        }
        List originRecords = (List)response.getData();
        List<XxlJobGroup> records = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)param.getSearchText())) {
            records = originRecords;
        } else {
            for (XxlJobGroup jobGroup : originRecords) {
                if (!jobGroup.getTitle().contains(param.getSearchText()) && !jobGroup.getAddressList().contains(param.getSearchText()) && !jobGroup.getAppName().contains(param.getSearchText())) continue;
                records.add(jobGroup);
            }
        }
        Page pageData = new Page(1L, 10L, (long)records.size());
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refJobGroupData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<XxlJobGroup>> refJobGroupData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        CommonResponse response = this.jobAdminApi.queryGroupList();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u67e5\u8be2\u6267\u884c\u5668\u5217\u8868\u5931\u8d25\uff01" + response.getMsg()));
        }
        List originRecords = (List)response.getData();
        List<XxlJobGroup> records = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            records = originRecords;
        } else {
            for (XxlJobGroup jobGroup : originRecords) {
                if (!jobGroup.getTitle().contains(searchText) && !jobGroup.getAddressList().contains(searchText) && !jobGroup.getAppName().contains(searchText)) continue;
                records.add(jobGroup);
            }
        }
        Page pageData = new Page(1L, 10L, (long)records.size());
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

