/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.service;

import cn.hutool.http.webservice.SoapClient;
import com.ejianc.business.cefoc.asip.vo.WsdlConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.wsdl.WSDLManager;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WebServiceClientUtil {
    public static String callWebService(WsdlConfig config, Map<String, Object> params) throws Exception {
        SoapClient client = SoapClient.create((String)config.getWsdlUrl()).setMethod("tns:" + config.getOperationName(), config.getNamespace()).setParams(params);
        String send = client.send(false);
        Document document = DocumentHelper.parseText((String)send);
        Element root = document.getRootElement();
        return root.getStringValue();
    }

    public static WsdlConfig parseWsdl(String wsdlUrl) throws Exception {
        WsdlConfig config = new WsdlConfig();
        config.setWsdlUrl(wsdlUrl);
        Bus bus = BusFactory.getDefaultBus();
        WSDLManager manager = (WSDLManager)bus.getExtension(WSDLManager.class);
        Definition definition = manager.getDefinition(wsdlUrl);
        config.setNamespace(definition.getTargetNamespace());
        Collection services = definition.getServices().values();
        if (!services.isEmpty()) {
            Service service = (Service)services.iterator().next();
            config.setServiceName(service.getQName().getLocalPart());
            Collection ports = service.getPorts().values();
            if (!ports.isEmpty()) {
                Port port = (Port)ports.iterator().next();
                config.setPortName(port.getName());
                List operations = port.getBinding().getBindingOperations();
                List operationNames = operations.stream().map(BindingOperation::getName).collect(Collectors.toList());
                config.setMethods(operationNames);
            }
        }
        return config;
    }
}

