/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.utils;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.bean.AppResourceConnectEntity;
import com.ejianc.business.cefoc.asip.utils.DPCommonUtils;
import com.ejianc.business.cefoc.asip.utils.DataProvider;
import com.ejianc.business.cefoc.asip.utils.Initializing;
import com.ejianc.business.cefoc.asip.utils.SqlHelper;
import com.ejianc.business.cefoc.asip.utils.sql.config.AggConfig;
import com.ejianc.business.cefoc.asip.utils.sql.dataprovider.Aggregatable;
import com.ejianc.business.cefoc.asip.utils.sql.exception.DBException;
import com.ejianc.business.cefoc.asip.utils.sql.result.AggregateResult;
import com.ejianc.framework.core.exception.BusinessException;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.hash.Hashing;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataProvider
extends DataProvider
implements Aggregatable,
Initializing {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDataProvider.class);
    private static final int resultLimit = 1000;
    private String DRIVER = "driver";
    private String JDBC_URL = "jdbcurl";
    private String USERNAME = "username";
    private String PASSWORD = "password";
    private String POOLED = "pooled";
    private String aggregateProvider = "aggregateProvider";
    private String SQL = "sql";
    private static final ConcurrentMap<String, DataSource> datasourceMap = new ConcurrentHashMap<String, DataSource>();
    private SqlHelper sqlHelper;

    private JdbcDataProvider() {
    }

    public static JdbcDataProvider getInstance() {
        return JdbcDataProviderInstance.instance;
    }

    public void assignVal(Map<String, String> dataSource, Map<String, String> query) {
        this.dataSource = dataSource;
        this.query = query;
    }

    @Override
    public boolean doAggregationInDataSource() {
        String v = (String)this.dataSource.get(this.aggregateProvider);
        return v != null && "true".equals(v);
    }

    public List<JSONObject> getDataList() {
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
        try {
            String[][] datas = this.getData();
            if (datas != null && datas.length > 1) {
                String[] headers = datas[0];
                for (int i = 1; i < datas.length; ++i) {
                    JSONObject jsonObject = new JSONObject();
                    for (int j = 0; j < datas[i].length; ++j) {
                        jsonObject.put(headers[j], (Object)datas[i][j]);
                    }
                    dataList.add(jsonObject);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataList;
    }

    public Integer executeUpdate() throws Exception {
        LOG.debug("Execute JdbcDataProvider.getData() Start!");
        String sql = this.getAsSubQuery((String)this.query.get(this.SQL));
        LOG.info("SQL String: " + sql);
        Connection con = null;
        PreparedStatement pstmt = null;
        Integer rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeUpdate();
            LOG.info("\u7ed3\u679c\uff1a{}", (Object)rs);
        }
        catch (Exception e) {
            LOG.info("\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new Exception("ERROR:" + e.getMessage(), e);
        }
        return rs;
    }

    @Override
    public String[][] getData() throws Exception {
        int batchSize = 100000;
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOG.debug("Execute JdbcDataProvider.getData() Start!");
        String sql = this.getAsSubQuery((String)this.query.get(this.SQL));
        LinkedList<String[]> list = null;
        LOG.info("SQL String: " + sql);
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            list = new LinkedList<String[]>();
            String[] row = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = metaData.getColumnLabel(i + 1);
            }
            String[] header = row;
            list.add(row);
            int resultCount = 0;
            int threadId = 0;
            ExecutorService executor = Executors.newFixedThreadPool(5);
            while (rs.next()) {
                ++resultCount;
                row = new String[columnCount];
                for (int j = 0; j < columnCount; ++j) {
                    row[j] = rs.getString(j + 1);
                }
                list.add(row);
                if (resultCount % 100000 == 0) {
                    LOG.info("JDBC load batch {}", (Object)resultCount);
                    String[][] batchData = (String[][])list.toArray((T[])new String[0][]);
                    Thread loadThread = new Thread(() -> this.getInnerAggregator().loadBatch(header, batchData), threadId++ + "");
                    executor.execute(loadThread);
                    list.clear();
                }
                if (resultCount <= 1000) continue;
                throw new DBException("Cube result count " + resultCount + ", is greater than limit " + 1000);
            }
            executor.shutdown();
            while (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            }
            String[][] batchData = (String[][])list.toArray((T[])new String[0][]);
            LOG.info("getData() using time: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            String[][] stringArray = batchData;
            return stringArray;
        }
        catch (Exception e) {
            LOG.error("ERROR:" + e.getMessage());
            throw new Exception("ERROR:" + e.getMessage(), e);
        }
        finally {
            rs.close();
            pstmt.close();
            con.close();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean testConnection() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, String> bulidDataSource(AppResourceConnectEntity uniqueBean) {
        HashMap<String, String> dataSourceMap = new HashMap<String, String>();
        if ("mysql".equals(uniqueBean.getDatabaseType())) {
            dataSourceMap.put("driver", "com.mysql.jdbc.Driver");
            dataSourceMap.put("jdbcurl", "jdbc:mysql://" + uniqueBean.getDatabaseHost() + ":" + uniqueBean.getDatabasePort() + "/" + uniqueBean.getDatabaseName() + "?useUnicode=true&characterEncoding=utf-8&autoReconnect=true&failOverReadOnly=false&useSSL=false");
        } else if ("oracle".equals(uniqueBean.getDatabaseType())) {
            dataSourceMap.put("driver", "oracle.jdbc.driver.OracleDriver");
            dataSourceMap.put("jdbcurl", "jdbc:oracle://" + uniqueBean.getDatabaseHost() + ":" + uniqueBean.getDatabasePort() + "/" + uniqueBean.getDatabaseName());
        } else if ("dameng".equals(uniqueBean.getDatabaseType())) {
            dataSourceMap.put("driver", "dm.jdbc.driver.DmDriver");
            dataSourceMap.put("jdbcurl", "jdbc:dm://" + uniqueBean.getDatabaseHost() + ":" + uniqueBean.getDatabasePort() + "/" + uniqueBean.getDatabaseName());
        } else if ("sqlserver".equals(uniqueBean.getDatabaseType())) {
            dataSourceMap.put("driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
            dataSourceMap.put("jdbcurl", "jdbc:sqlserver://" + uniqueBean.getDatabaseHost() + ":" + uniqueBean.getDatabasePort() + ";databaseName=" + uniqueBean.getDatabaseName());
        }
        dataSourceMap.put("username", uniqueBean.getDatabaseUser());
        dataSourceMap.put("password", uniqueBean.getDatabasePassword());
        dataSourceMap.put("pooled", "true");
        return dataSourceMap;
    }

    private String getAsSubQuery(String rawQueryText) {
        String deletedBlankLine = rawQueryText.replaceAll("(?m)^[\\s\t]*\r?\n", "").trim();
        return deletedBlankLine.endsWith(";") ? deletedBlankLine.substring(0, deletedBlankLine.length() - 1) : deletedBlankLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws Exception {
        String usePool = (String)this.dataSource.get(this.POOLED);
        String username = (String)this.dataSource.get(this.USERNAME);
        String password = (String)this.dataSource.get(this.PASSWORD);
        if (StringUtils.isBlank((String)usePool)) {
            usePool = "true";
        }
        if ("true".equals(usePool)) {
            String key = Hashing.md5().newHasher().putString((CharSequence)JSONObject.toJSON((Object)this.dataSource).toString(), Charsets.UTF_8).hash().toString();
            DataSource ds = (DataSource)datasourceMap.get(key);
            if (ds == null) {
                String string = key.intern();
                synchronized (string) {
                    ds = (DataSource)datasourceMap.get(key);
                    if (ds == null) {
                        HashedMap conf = new HashedMap();
                        conf.put("driverClassName", this.dataSource.get(this.DRIVER));
                        conf.put("url", this.dataSource.get(this.JDBC_URL));
                        conf.put("username", this.dataSource.get(this.USERNAME));
                        if (StringUtils.isNotBlank((String)password)) {
                            conf.put("password", this.dataSource.get(this.PASSWORD));
                        }
                        conf.put("initialSize", "100");
                        conf.put("minIdle", "50");
                        conf.put("maxActive", "200");
                        conf.put("maxWait", "10000");
                        conf.put("timeBetweenEvictionRunsMillis", "300000");
                        conf.put("minEvictableIdleTimeMillis", "300000");
                        conf.put("testWhileIdle", "true");
                        conf.put("testOnBorrow", "false");
                        conf.put("testOnReturn", "false");
                        conf.put("poolPreparedStatements", "true");
                        conf.put("removeAbandoned", "true");
                        conf.put("removeAbandonedTimeout", "600");
                        DruidDataSource druidDS = (DruidDataSource)DruidDataSourceFactory.createDataSource((Map)conf);
                        druidDS.setBreakAfterAcquireFailure(true);
                        druidDS.setConnectionErrorRetryAttempts(5);
                        datasourceMap.put(key, (DataSource)druidDS);
                        ds = (DataSource)datasourceMap.get(key);
                    }
                }
            }
            Connection conn = null;
            try {
                conn = ds.getConnection();
            }
            catch (SQLException e) {
                datasourceMap.remove(key);
                throw e;
            }
            return conn;
        }
        String driver = (String)this.dataSource.get(this.DRIVER);
        String jdbcurl = (String)this.dataSource.get(this.JDBC_URL);
        Class.forName(driver);
        Properties props = new Properties();
        props.setProperty("user", username);
        if (StringUtils.isNotBlank((String)password)) {
            props.setProperty("password", password);
        }
        return DriverManager.getConnection(jdbcurl, props);
    }

    @Override
    public String[] queryDimVals(String columnName, AggConfig config) throws Exception {
        String fsql = null;
        String exec = null;
        String sql = this.getAsSubQuery((String)this.query.get(this.SQL));
        ArrayList<String> filtered = new ArrayList<String>();
        String whereStr = "";
        if (config != null) {
            whereStr = this.sqlHelper.assembleFilterSql(config);
        }
        fsql = "SELECT cb_view.%s FROM (\n%s\n) cb_view %s GROUP BY cb_view.%s";
        exec = String.format(fsql, columnName, sql, whereStr, columnName);
        LOG.info(exec);
        try (Connection connection = this.getConnection();
             Statement stat = connection.createStatement();
             ResultSet rs = stat.executeQuery(exec);){
            while (rs.next()) {
                filtered.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            LOG.error("ERROR:" + e.getMessage());
            throw new Exception("ERROR:" + e.getMessage(), e);
        }
        return filtered.toArray(new String[0]);
    }

    private ResultSetMetaData getMetaData(String subQuerySql, Statement stat) throws Exception {
        ResultSetMetaData metaData;
        try {
            stat.setMaxRows(100);
            String fsql = "\nSELECT * FROM (\n%s\n) cb_view WHERE 1=0";
            String sql = String.format(fsql, subQuerySql);
            LOG.info(sql);
            ResultSet rs = stat.executeQuery(sql);
            metaData = rs.getMetaData();
        }
        catch (Exception e) {
            LOG.error("ERROR:" + e.getMessage());
            throw new Exception("ERROR:" + e.getMessage(), e);
        }
        return metaData;
    }

    /*
     * Exception decompiling
     */
    private Map<String, Integer> getColumnType() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] getColumn(boolean reload) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, String> getSelectColumn(boolean reload) throws Exception {
        String[] columns;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String column : columns = this.getColumn(reload)) {
            map.put(column, column);
        }
        return map;
    }

    @Override
    public AggregateResult queryAggData(AggConfig config) throws Exception {
        String exec = this.sqlHelper.assembleAggDataSql(config);
        LinkedList<String[]> list = new LinkedList<String[]>();
        LOG.info(exec);
        try (Connection connection = this.getConnection();
             Statement stat = connection.createStatement();
             ResultSet rs = stat.executeQuery(exec);){
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                String[] row = new String[columnCount];
                for (int j = 0; j < columnCount; ++j) {
                    row[j] = rs.getString(j + 1);
                }
                list.add(row);
            }
        }
        catch (Exception e) {
            LOG.error("ERROR:" + e.getMessage());
            throw new Exception("ERROR:" + e.getMessage(), e);
        }
        return DPCommonUtils.transform2AggResult(config, list);
    }

    @Override
    public String viewAggDataQuery(AggConfig config) throws Exception {
        return this.sqlHelper.assembleAggDataSql(config);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        String subQuery = null;
        if (this.query != null) {
            subQuery = this.getAsSubQuery((String)this.query.get(this.SQL));
        }
        SqlHelper sqlHelper = new SqlHelper(subQuery, true);
        if (!this.isUsedForTest()) {
            Map<String, Integer> columnTypes = null;
            try {
                columnTypes = this.getColumnType();
            }
            catch (Exception e) {
                LOG.warn("getColumnType failed: {}", (Object)e.getMessage());
            }
            sqlHelper.getSqlSyntaxHelper().setColumnTypes(columnTypes);
        }
        this.sqlHelper = sqlHelper;
    }

    public static void main(String[] args) {
        AppResourceConnectEntity uniqueBean = new AppResourceConnectEntity();
        uniqueBean.setDatabaseName("cefoc_asip");
        uniqueBean.setDatabaseHost("192.168.202.113");
        uniqueBean.setDatabasePort("3306");
        uniqueBean.setDatabaseUser("root");
        uniqueBean.setDatabasePassword("t7xjfbKEd4np");
        uniqueBean.setDatabaseType("mysql");
        String sql = "INSERT INTO `cefoc_asip`.`cefoc_asip_apply_interface`(`id`, `wait_id`, `interface_id`, `interface_name`, `interface_address`, `interface_describe`, `user_id`, `apply_id`, `client_id`, `client_secret`, `state`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`) VALUES (996360518543347747, 996360485307682888, 995367948086415412, '\u6d4b\u8bd5sql1', 'cefoc-asip-web/asipapi/sql/handler/testsql', NULL, 1247777316689256450, 996360518497210372, '1941321377575342081', 'MTk0MTMyMTM3NzU3NTM0MjA4MQ==', 1, '', '2025-07-05 10:20:59', '', '2025-07-05 17:44:45', 0, 999999, 0, 6);\n";
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("sql", sql);
        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        Map<String, String> dataSourceMap = jdbcDataProvider.bulidDataSource(uniqueBean);
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            jdbcDataProvider.executeUpdate();
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u5931\u8d25");
        }
    }

    private static class JdbcDataProviderInstance {
        private static final JdbcDataProvider instance = new JdbcDataProvider();

        private JdbcDataProviderInstance() {
        }
    }
}

