package com.ejianc.business.assist.ownrmat.vo;

import com.ejianc.business.store.vo.FlowVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;


/**
 * 仓库流水表
 *
 * @author generator
 *
 */
@ApiModel("仓库流水表")
public class FlowReportVO extends FlowVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("在场数量")
    private BigDecimal presentNum;
    @ApiModelProperty("使用数量")
    private BigDecimal useNum;
    @ApiModelProperty("闲置数量")
    private BigDecimal idleNum;
    @ApiModelProperty("原值金额(无税)")
    private BigDecimal purchaseMny;
    @ApiModelProperty("原值金额")
    private BigDecimal purchaseTaxMny;
    @ApiModelProperty("残值金额(无税)")
    private BigDecimal residualMny;
    @ApiModelProperty("残值金额")
    private BigDecimal residualTaxMny;
    @ApiModelProperty("闲置数量记录主键")
    private Long idleRecordId;
    @ApiModelProperty("采购单位+项目+物料联合主键")
    private String orgProMateIds;

    List<FlowReportVO> detailList;// 明细

    public BigDecimal getPresentNum() {
        return presentNum;
    }

    public void setPresentNum(BigDecimal presentNum) {
        this.presentNum = presentNum;
    }

    public BigDecimal getUseNum() {
        return useNum;
    }

    public void setUseNum(BigDecimal useNum) {
        this.useNum = useNum;
    }

    public BigDecimal getIdleNum() {
        return idleNum;
    }

    public void setIdleNum(BigDecimal idleNum) {
        this.idleNum = idleNum;
    }

    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }

    public BigDecimal getPurchaseTaxMny() {
        return purchaseTaxMny;
    }

    public void setPurchaseTaxMny(BigDecimal purchaseTaxMny) {
        this.purchaseTaxMny = purchaseTaxMny;
    }

    public BigDecimal getResidualMny() {
        return residualMny;
    }

    public void setResidualMny(BigDecimal residualMny) {
        this.residualMny = residualMny;
    }

    public BigDecimal getResidualTaxMny() {
        return residualTaxMny;
    }

    public void setResidualTaxMny(BigDecimal residualTaxMny) {
        this.residualTaxMny = residualTaxMny;
    }

    public Long getIdleRecordId() {
        return idleRecordId;
    }

    public void setIdleRecordId(Long idleRecordId) {
        this.idleRecordId = idleRecordId;
    }

    public String getOrgProMateIds() {
        return orgProMateIds;
    }

    public void setOrgProMateIds(String orgProMateIds) {
        this.orgProMateIds = orgProMateIds;
    }

    public List<FlowReportVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<FlowReportVO> detailList) {
        this.detailList = detailList;
    }
}
