package com.ejianc.business.assist.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 周转材租赁合同-合同条款变更表
 * 
 * @author generator
 * 
 */
public class ChangeClauseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long changeId; // 变更主键
    private String changeType; // 变更类型
    private Long contractId; // 合同id
    private Long sourceId; // 来源数据Id(参照数据id)
    private Long sourceBid; // 来源子表主键(合同子表id)
    private String sourceType; // 来源类型：0-直接新增，1-定标结果带入
    private Long clauseNameId; // 合同条款名称Id
    private String clauseName; // 合同条款名称
    private String clauseContent; // 合同条款内容

    private String bcClauseName; // 变更前合同条款名称
    private String bcClauseContent; // 变更前合同条款内容

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @ReferSerialTransfer(referCode="contractClause")
    public Long getClauseNameId() {
        return clauseNameId;
    }

    @ReferDeserialTransfer
    public void setClauseNameId(Long clauseNameId) {
        this.clauseNameId = clauseNameId;
    }
    public String getClauseName() {
        return clauseName;
    }

    public void setClauseName(String clauseName) {
        this.clauseName = clauseName;
    }
    public String getClauseContent() {
        return clauseContent;
    }

    public void setClauseContent(String clauseContent) {
        this.clauseContent = clauseContent;
    }

    public String getBcClauseName() {
        return bcClauseName;
    }

    public void setBcClauseName(String bcClauseName) {
        this.bcClauseName = bcClauseName;
    }

    public String getBcClauseContent() {
        return bcClauseContent;
    }

    public void setBcClauseContent(String bcClauseContent) {
        this.bcClauseContent = bcClauseContent;
    }
}
