package com.ejianc.business.assist.rmat.vo.record;

import com.ejianc.business.assist.rmat.vo.ContractFreezeVO;

import java.util.ArrayList;
import java.util.List;

public class FreezeRecordVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long mainContractId;
    
    /**
     * 合同履约状态：0-未签订，1-履约中，2-已封账，3-已解除，4-已冻结
     */
    private String contractStatus;
    
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
     */
    private Integer signatureStatus;
    
    private List<ContractFreezeVO> detailList = new ArrayList<>();


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public List<ContractFreezeVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractFreezeVO> detailList) {
        this.detailList = detailList;
    }
    
}
