package com.ejianc.business.assist.material.vo;

public enum MaterialBatchPlanEnum {

    /** 待采购 */
    PLAN_STATE_WAIT(0, "待采购"),
    /** 采购中 */
    PLAN_STATE_EXEC(1, "采购中"),
    /** 采购完成 */
    PLAN_STATE_OVER(2, "采购完成");

    private final Integer planState;
    private final String description;

    MaterialBatchPlanEnum(Integer planState, String description) {
        this.planState = planState;
        this.description = description;
    }

    /**
     * 获取采购状态
     * @return 采购状态
     */
    public Integer getPlanState() {
        return this.planState;
    }

    /**
     * 获取采购状态注释
     * @return 采购状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据采购状态获取采购状态枚举
     * @param planState 采购状态
     * @return 采购状态枚举
     */
    public static MaterialBatchPlanEnum getEnumByStateCode(Integer planState) {
        for (MaterialBatchPlanEnum bat : MaterialBatchPlanEnum.values()) {
            if (bat.getPlanState().equals(planState)) return bat;
        }
        return null;
    }

    /**
     * 根据采购状态获取采购状态注释
     * @param planState 采购状态
     * @return 采购状态注释
     */
    public static String getDescriptionByStateCode(Integer planState){
        MaterialBatchPlanEnum batPlanEnum = getEnumByStateCode(planState);
        if (batPlanEnum != null) return batPlanEnum.getDescription();
        return null;
    }
}
