package com.ejianc.business.assist.material.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 辅料中心采购结算单
 *
 * @author generator
 */
public class MaterialSettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField
    private String billCode; // 单据编号
    @ConvertField
    private Integer billState; // 单据状态
    @ConvertField
    private Long projectId; // 项目id
    @ConvertField
    private String projectCode; // 项目编码
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private Long orgId; // 项目组织id
    @ConvertField
    private String orgCode; // 项目组织编码
    @ConvertField
    private String orgName; // 项目组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织id
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    @ConvertField
    private Long contractId; // 合同id
    @ConvertField
    private String contractCode; // 合同编号
    @ConvertField
    private String contractName; // 合同名称
    @ConvertField(targetField = "partyaId")
    private Long firstPartyId; // 甲方Id
    @ConvertField(targetField = "partyaName")
    private String firstPartyName; // 甲方名称
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 乙方Id
    @ConvertField(targetField = "partybName")
    private String supplierName; // 乙方名称
    private String settleType; // 结算类型：0-过程结算，1-最终结算
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    @ConvertField
    private Long employeeId; // 经办人id
    @ConvertField
    private String employeeName; // 经办人名称
    @ConvertField
    private Long departmentId; // 经办部门
    @ConvertField
    private String departmentName; // 经办部门名称
    private Integer supplierSignStatus; // 供方签字状态：0-未签字，1-已签字
    private String supOperatorUserCode; // 供方经办人账号
    private String supOperatorName; // 供方经办人名称
    private String supOperatorPhone; // 供方经办人手机号
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date supOperateTime; // 供方经办人签字时间
    @ConvertField
    private String memo; // 备注
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal settleTaxMny; // 本期结算金额
    @ConvertField(targetField = "curMny")
    private BigDecimal settleMny; // 本期结算金额(无税)
    @ConvertField(targetField = "curTax")
    private BigDecimal settleTax; // 本期结算税额
    private BigDecimal materialTaxMny; // 材料金额
    private BigDecimal materialMny; // 材料金额(无税)
    private BigDecimal materialTax; // 材料税额
    private BigDecimal otherTaxMny; // 其他金额
    private BigDecimal otherMny; // 其他金额(无税)
    private BigDecimal otherTax; // 其他税额
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(无税)
    private BigDecimal contractTax; // 合同税额
    private BigDecimal contractTaxRate; // 合同税率
    @ConvertField(targetField = "lastTaxMny")
    private BigDecimal lastSettleTaxMny; // 不含本期已结算金额
    @ConvertField(targetField = "lastMny")
    private BigDecimal lastSettleMny; // 不含本期已结算金额(无税)
    @ConvertField(targetField = "lastTax")
    private BigDecimal lastSettleTax; // 不含本期已结算税额
    private BigDecimal totalSettleTaxMny; // 含本期已结算金额
    private BigDecimal totalSettleMny; // 含本期已结算金额(无税)
    private BigDecimal totalSettleTax; // 含本期已结算税额
    private BigDecimal totalPayTaxMny; // 累计已付金额
    private BigDecimal totalPayMny; // 累计已付金额(无税)
    private BigDecimal totalPayTax; // 累计已付税额
    private BigDecimal totalInvoiceTaxMny; // 累计收票金额
    private BigDecimal totalInvoiceMny; // 累计收票金额(无税)
    private BigDecimal totalInvoiceTax; // 累计收票税额
    private BigDecimal contractPayRate; // 合同支付比例
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private String pushPoolFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方

    private String supplierSignStatusName; // 签字状态名称
    private String billStateName; // 单据状态名称
    
    private List<MaterialSettleDetailVO> materialSettleDetailList = new ArrayList<>(); // 辅料中心采购结算单-材料明细
    private List<MaterialSettleOtherVO> materialSettleOtherList = new ArrayList<>(); // 辅料中心采购结算单-其他费用

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "assistmaterial_contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }

    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }

    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public BigDecimal getLastSettleTaxMny() {
        return lastSettleTaxMny;
    }

    public void setLastSettleTaxMny(BigDecimal lastSettleTaxMny) {
        this.lastSettleTaxMny = lastSettleTaxMny;
    }

    public BigDecimal getLastSettleMny() {
        return lastSettleMny;
    }

    public void setLastSettleMny(BigDecimal lastSettleMny) {
        this.lastSettleMny = lastSettleMny;
    }

    public BigDecimal getLastSettleTax() {
        return lastSettleTax;
    }

    public void setLastSettleTax(BigDecimal lastSettleTax) {
        this.lastSettleTax = lastSettleTax;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTax() {
        return totalSettleTax;
    }

    public void setTotalSettleTax(BigDecimal totalSettleTax) {
        this.totalSettleTax = totalSettleTax;
    }

    public BigDecimal getTotalPayTaxMny() {
        return totalPayTaxMny;
    }

    public void setTotalPayTaxMny(BigDecimal totalPayTaxMny) {
        this.totalPayTaxMny = totalPayTaxMny;
    }

    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }

    public BigDecimal getTotalPayTax() {
        return totalPayTax;
    }

    public void setTotalPayTax(BigDecimal totalPayTax) {
        this.totalPayTax = totalPayTax;
    }

    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }

    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }

    public BigDecimal getTotalInvoiceTax() {
        return totalInvoiceTax;
    }

    public void setTotalInvoiceTax(BigDecimal totalInvoiceTax) {
        this.totalInvoiceTax = totalInvoiceTax;
    }

    public BigDecimal getContractPayRate() {
        return contractPayRate;
    }

    public void setContractPayRate(BigDecimal contractPayRate) {
        this.contractPayRate = contractPayRate;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getSupplierSignStatusName() {
        return supplierSignStatusName;
    }

    public void setSupplierSignStatusName(String supplierSignStatusName) {
        this.supplierSignStatusName = supplierSignStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<MaterialSettleDetailVO> getMaterialSettleDetailList() {
        return materialSettleDetailList;
    }

    public void setMaterialSettleDetailList(List<MaterialSettleDetailVO> materialSettleDetailList) {
        this.materialSettleDetailList = materialSettleDetailList;
    }

    public List<MaterialSettleOtherVO> getMaterialSettleOtherList() {
        return materialSettleOtherList;
    }

    public void setMaterialSettleOtherList(List<MaterialSettleOtherVO> materialSettleOtherList) {
        this.materialSettleOtherList = materialSettleOtherList;
    }
}
