package com.ejianc.business.assist.store.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 其他入库
 * 
 * @author generator
 * 
 */
public class OtherInVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long orgId; // 所属组织
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称
    private Long storeId; // 仓库
    private String storeName; // 仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 验收日期
    private String materialTypes; // 物料分类
    private BigDecimal instoreTaxMny; // 入库金额(无税)
    private BigDecimal instoreMny; // 入库金额(含税)
    private Long employeeId; // 业务经办人ID
    private String employeeName; // 业务经办人名称
    private String memo; // 备注
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Integer recordFlag; // 是否补录：0-否，1-是
    private Integer weighFlag; // 是否地磅称重：0-否，1-是
    private Integer requirFlag; // 是否符合要求：0-否，1-是
    private Integer sourceType; // 单据来源：0-自制
    private String sourceTypeName;
    private String billStateName; //单据状态名称

    private List<OtherInDetailVO> otherInDetailList;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="store-store")
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getMaterialTypes() {
        return materialTypes;
    }

    public void setMaterialTypes(String materialTypes) {
        this.materialTypes = materialTypes;
    }
    public BigDecimal getInstoreTaxMny() {
        return instoreTaxMny;
    }

    public void setInstoreTaxMny(BigDecimal instoreTaxMny) {
        this.instoreTaxMny = instoreTaxMny;
    }
    public BigDecimal getInstoreMny() {
        return instoreMny;
    }

    public void setInstoreMny(BigDecimal instoreMny) {
        this.instoreMny = instoreMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getRecordFlag() {
        return recordFlag;
    }

    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }
    public Integer getWeighFlag() {
        return weighFlag;
    }

    public void setWeighFlag(Integer weighFlag) {
        this.weighFlag = weighFlag;
    }
    public Integer getRequirFlag() {
        return requirFlag;
    }

    public void setRequirFlag(Integer requirFlag) {
        this.requirFlag = requirFlag;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<OtherInDetailVO> getOtherInDetailList() {
        return otherInDetailList;
    }

    public void setOtherInDetailList(List<OtherInDetailVO> otherInDetailList) {
        this.otherInDetailList = otherInDetailList;
    }
}
