package com.ejianc.business.assist.store.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 原材料加工
 * 
 * @author generator
 * 
 */
public class ProcessVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long orgId; // 所属组织
    private String orgCode; // 组织编码
    private String orgName; // 所属组织名称
    private Long storeId; // 入库仓库
    private String storeName; // 入库仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date processDate; // 加工日期
    private BigDecimal costMny; // 成本金额(无税)
    private BigDecimal costTaxMny; // 成本金额
    private BigDecimal processCostMny; // 加工成本金额
    private BigDecimal processCostTaxMny; // 加工成本金额
    private Long employeeId; // 业务经办人ID
    private String employeeName; // 业务经办人名称
    private String processReason; // 加工原因
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String outStoreNames; // 出库仓库名称
    private String billStateName; //单据状态名称

    private List<ProcessRawVO> processRawList; // 原材料明细实体
    private List<ProcessCostVO> processCostList; // 加工费明细
    private List<ProcessProductVO> processProductList; // 成品明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="store-store")
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getProcessDate() {
        return processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    public BigDecimal getProcessCostMny() {
        return processCostMny;
    }

    public void setProcessCostMny(BigDecimal processCostMny) {
        this.processCostMny = processCostMny;
    }

    public BigDecimal getProcessCostTaxMny() {
        return processCostTaxMny;
    }

    public void setProcessCostTaxMny(BigDecimal processCostTaxMny) {
        this.processCostTaxMny = processCostTaxMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getProcessReason() {
        return processReason;
    }

    public void setProcessReason(String processReason) {
        this.processReason = processReason;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getOutStoreNames() {
        return outStoreNames;
    }

    public void setOutStoreNames(String outStoreNames) {
        this.outStoreNames = outStoreNames;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<ProcessRawVO> getProcessRawList() {
        return processRawList;
    }

    public void setProcessRawList(List<ProcessRawVO> processRawList) {
        this.processRawList = processRawList;
    }

    public List<ProcessCostVO> getProcessCostList() {
        return processCostList;
    }

    public void setProcessCostList(List<ProcessCostVO> processCostList) {
        this.processCostList = processCostList;
    }

    public List<ProcessProductVO> getProcessProductList() {
        return processProductList;
    }

    public void setProcessProductList(List<ProcessProductVO> processProductList) {
        this.processProductList = processProductList;
    }
}
