package com.ejianc.business.assist.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 验收单
 *
 * @author generator
 *
 */
public class MaterialCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long orderId; // 订单主键
    private Long deliveryId; // 发货主键
    private String deliveryBillCode; // 送货单单据编号
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String contractRmatMethod; // 合同租赁方式
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long supplierId; // 设备供应商
    private String supplierName; // 供应商名称
    private Long firstPartyId; // 甲方Id
    private String firstPartyName; // 甲方名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 验收日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rmatDate; // 计租日期
    private String licensePlate; // 车牌号
    private String memo; // 备注
    private String checkSource; // 验收来源(0-自制，1-送货单)
    private String checkSourceName; // 验收来源(送货单单据编号或自制)
    private Integer supplierSignStatus; // 供方签字状态:已签字-1,未签字-0
    private String supplementRecord; // 是否补录(0-否，1-是)
    private boolean shareBtnVisible; // 供方协同按钮是否显示
    private String billPushFlag;// 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方


    /**
     * 制单人Id
     */
    private Long createUserId;

    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    private Long supOperateFileId;

    /**
     * 是否支持若协同：0-不支持，1-支持
     */
    private Integer waekFlag;

    /***  协同需要字段 END  ***/




    private Long checkOrgId; // 验收组织id
    private String checkOrgName; // 验收组织名称
    private String checkOrgCode; // 验收组织编码
    private String loadometerWeight; // 是否地磅称重(0-否，1-是)
    private String checkType; // 验收方式(0-收料入库，1-直入直出)
    private Long outContractId; // 租出合同主键
    private String outContractCode; // 租出合同编码
    private String outContractName; // 租出合同名称
    private Long outProjectId; // 租出项目id
    private String outProjectCode; // 租出项目编码
    private String outProjectName; // 租出项目名称
    private Long outOrgId; // 租出组织id
    private String outOrgName; // 租出组织名称
    private String outOrgCode; // 租出组织编码
    private Long outParentOrgId; // 租出父级组织
    private String outParentOrgCode; // 租出父级组织编码
    private String outParentOrgName; // 租出父级组织名称
    private Long outLinkId; // 租出联系人
    private String outLinkName; // 租出联系人名称
    private String outLinkTelephone; // 租出联系人电话
    private String passMuster; // 是否符合要求(0-否，1-是)

    private Long storeId; //仓库id
    private String storeName; //仓库名称
    private BigDecimal checkMny; //清单金额(无税)
    private BigDecimal checkTaxMny; //清单金额(无税)
    private BigDecimal checkTax; //清单税额

    private Integer settleFlag; // 是否结算：0-否，1-是
    
    private List<MaterialCheckDetailVO> checkDetailList = new ArrayList<>(); // 验收单明细


    @ReferSerialTransfer(referCode="assist-store")
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }

    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }

    public BigDecimal getCheckTax() {
        return checkTax;
    }

    public void setCheckTax(BigDecimal checkTax) {
        this.checkTax = checkTax;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public String getDeliveryBillCode() {
        return deliveryBillCode;
    }

    public void setDeliveryBillCode(String deliveryBillCode) {
        this.deliveryBillCode = deliveryBillCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "am_contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractRmatMethod() {
        return contractRmatMethod;
    }

    public void setContractRmatMethod(String contractRmatMethod) {
        this.contractRmatMethod = contractRmatMethod;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }


    public String getSupplierName() {
        return supplierName;
    }
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Date getRmatDate() {
        return rmatDate;
    }

    public void setRmatDate(Date rmatDate) {
        this.rmatDate = rmatDate;
    }
    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCheckSource() {
        return checkSource;
    }

    public void setCheckSource(String checkSource) {
        this.checkSource = checkSource;
    }
    public List<MaterialCheckDetailVO> getCheckDetailList() {
        return checkDetailList;
    }

    public void setCheckDetailList(List<MaterialCheckDetailVO> checkDetailList) {
        this.checkDetailList = checkDetailList;
    }

    public String getCheckSourceName() {
        return checkSourceName;
    }

    public void setCheckSourceName(String checkSourceName) {
        this.checkSourceName = checkSourceName;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public Integer getWaekFlag() {
        return waekFlag;
    }

    public void setWaekFlag(Integer waekFlag) {
        this.waekFlag = waekFlag;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public String getSupplementRecord() {
        return supplementRecord;
    }

    public void setSupplementRecord(String supplementRecord) {
        this.supplementRecord = supplementRecord;
    }

    public boolean isShareBtnVisible() {
        return shareBtnVisible;
    }

    public void setShareBtnVisible(boolean shareBtnVisible) {
        this.shareBtnVisible = shareBtnVisible;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getCheckOrgId() {
        return checkOrgId;
    }
    @ReferDeserialTransfer
    public void setCheckOrgId(Long checkOrgId) {
        this.checkOrgId = checkOrgId;
    }

    public String getCheckOrgName() {
        return checkOrgName;
    }

    public void setCheckOrgName(String checkOrgName) {
        this.checkOrgName = checkOrgName;
    }

    public String getCheckOrgCode() {
        return checkOrgCode;
    }

    public void setCheckOrgCode(String checkOrgCode) {
        this.checkOrgCode = checkOrgCode;
    }

    public String getLoadometerWeight() {
        return loadometerWeight;
    }

    public void setLoadometerWeight(String loadometerWeight) {
        this.loadometerWeight = loadometerWeight;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    @ReferSerialTransfer(referCode = "prormat_contract")
    public Long getOutContractId() {
        return outContractId;
    }
    @ReferDeserialTransfer
    public void setOutContractId(Long outContractId) {
        this.outContractId = outContractId;
    }

    public String getOutContractName() {
        return outContractName;
    }

    public void setOutContractName(String outContractName) {
        this.outContractName = outContractName;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getOutProjectId() {
        return outProjectId;
    }
    @ReferDeserialTransfer
    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }

    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOutOrgId() {
        return outOrgId;
    }
    @ReferDeserialTransfer
    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOutParentOrgId() {
        return outParentOrgId;
    }
    @ReferDeserialTransfer
    public void setOutParentOrgId(Long outParentOrgId) {
        this.outParentOrgId = outParentOrgId;
    }

    public String getOutParentOrgCode() {
        return outParentOrgCode;
    }

    public void setOutParentOrgCode(String outParentOrgCode) {
        this.outParentOrgCode = outParentOrgCode;
    }

    public String getOutParentOrgName() {
        return outParentOrgName;
    }

    public void setOutParentOrgName(String outParentOrgName) {
        this.outParentOrgName = outParentOrgName;
    }

    public Long getOutLinkId() {
        return outLinkId;
    }

    public void setOutLinkId(Long outLinkId) {
        this.outLinkId = outLinkId;
    }

    public String getOutLinkName() {
        return outLinkName;
    }

    public void setOutLinkName(String outLinkName) {
        this.outLinkName = outLinkName;
    }

    public String getOutLinkTelephone() {
        return outLinkTelephone;
    }

    public void setOutLinkTelephone(String outLinkTelephone) {
        this.outLinkTelephone = outLinkTelephone;
    }

    public String getPassMuster() {
        return passMuster;
    }

    public void setPassMuster(String passMuster) {
        this.passMuster = passMuster;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public String getOutContractCode() {
        return outContractCode;
    }

    public void setOutContractCode(String outContractCode) {
        this.outContractCode = outContractCode;
    }

    public String getOutProjectCode() {
        return outProjectCode;
    }

    public void setOutProjectCode(String outProjectCode) {
        this.outProjectCode = outProjectCode;
    }
}
