package com.ejianc.business.assist.rmat.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 流水类型
 */
public enum FlowTypeEnum {

    验收(1, "验收", "check"),
    停用(2, "停用", "stop"),
    启用(3, "启用", "start"),
    退赔(4, "退赔", "rest"),
    遗失(5, "遗失", "lose");


    /**
     * 流水类型编码,参照枚举对象
     */
    private Integer flowType;

    /**
     * 流水类型名称,参照枚举对象
     */
    private String flowTypeName;

    /**
     * 流水类型标识
     */
    private String flowFlag;

    private static Map<Integer, FlowTypeEnum> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(FlowTypeEnum.class).stream().collect(Collectors.toMap(FlowTypeEnum::getFlowType, Function.identity(), (k1, k2) -> k2));
    }

    /**
     * 根据入库类型编码,获取枚举对象
     */
    public static FlowTypeEnum getEnumByInOutType(Integer flowType) {
        return enumMap.get(flowType);
    }

    FlowTypeEnum(Integer flowType, String flowTypeName, String flowFlag) {
        this.flowType = flowType;
        this.flowTypeName = flowTypeName;
        this.flowFlag = flowFlag;
    }

    public Integer getFlowType() {
        return flowType;
    }

    public void setFlowType(Integer flowType) {
        this.flowType = flowType;
    }

    public String getFlowTypeName() {
        return flowTypeName;
    }

    public void setFlowTypeName(String flowTypeName) {
        this.flowTypeName = flowTypeName;
    }

    public String getFlowFlag() {
        return flowFlag;
    }

    public void setFlowFlag(String flowFlag) {
        this.flowFlag = flowFlag;
    }
}
