package com.ejianc.business.assist.rmat.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 周转材租赁合同
 *
 * @author generator
 */
public class ContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 合同类型：主合同
     */
    public static final Integer CONTRACT_TYPE_MAIN_CONTRACT = 0;
    /**
     * 合同类型：补充协议
     */
    public static final Integer CONTRACT_TYPE_SUPPLEMENT = 1;


    @ConvertField(targetField = "contractCode")
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    @ConvertField
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private Long orgId; // 项目组织ID
    @ConvertField
    private String orgCode; // 项目组织编码
    @ConvertField
    private String orgName; // 项目组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织ID
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    private Integer addType; // 合同新增方式：0-参照定标结果新增，1-直接新增
    private String rentType; // 租赁方式：0-外租，1-内租
    private Long targetResultId; // 定标结果Id
    private String targetResultName; // 定标结果名称
    @ConvertField
    private String contractName; // 合同名称
    private String projectAddress; // 项目地址
    @ConvertField(targetField = "categoryId")
    private Long contractCategoryId; // 合同类别Id
    @ConvertField(targetField = "categoryName")
    private String contractCategoryName; // 合同类别名称
    @ConvertField(targetField = "partyaId")
    private Long firstPartyId; // 甲方Id
    @ConvertField(targetField = "partyaName")
    private String firstPartyName; // 甲方名称
    private Long firstPartyProjectManagerId; // 甲方项目负责人Id
    private String firstPartyProjectManagerName; // 甲方项目负责人名称
    @ConvertField(targetField = "employeeId")
    private Long firstPartyEmployeeId; // 甲方经办人id
    @ConvertField(targetField = "employeeName")
    private String firstPartyEmployeeName; // 甲方经办人名称
    @ConvertField(targetField = "employeePhone")
    private String firstPartyPhone; // 甲方电话
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 乙方Id
    @ConvertField(targetField = "partybName")
    private String supplierName; // 乙方名称
    private Long supplierEmployeeId; // 乙方经办人id
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierPhone; // 乙方电话
    private String supplierAddress; // 乙方地址
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private Integer monthSettlementDay; // 月结算日
    @ConvertField(targetField = "contractStartDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentCalculationDate; // 计租日期
    @ConvertField(targetField = "contractFinishDate")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endRentCalculationDate; // 止租日期
    @ConvertField
    private BigDecimal contractMny; // 合同金额(不含税)
    @ConvertField
    private BigDecimal contractTaxMny; // 合同金额
    @ConvertField
    private BigDecimal taxRate; // 合同税率
    @ConvertField(targetField = "contractTax")
    private BigDecimal tax; // 合同税额
    @ConvertField(targetField = "signPlace")
    private String supplyAddress; // 供货地点
    @ConvertField(targetField = "performanceStatus")
    private String performanceStatus; // 合同履约状态：1-未签订，2-履约中，3-已终止，4-已作废，5-已冻结，6-已结束
    private String draftType; // 起草方式：0-在线起草，1-上传合同，2-线下签订
    private Integer signatureStatus; // 签章状态：0-未签章，2-待乙方签章，3-待甲方签章，4-已签章
    private String contractFilePath; // 合同附件路径
    private Long contractFileId; // 合同附件Id
    private Long contractTemplateId; // 合同模板Id
    private String contractTemplateName; // 合同模板名称
    private Long contractFileVersionId; // 合同附件版本Id
    private Long contractFileVersion; // 合同附件版本
    private String contractFileHighlightPath; // 合同高亮附件路径
    private Long contractFileHighlightId; // 合同高亮附件Id
    @ConvertField
    private BigDecimal baseMny; // 初始版本金额(不含税)
    @ConvertField
    private BigDecimal baseTaxMny; // 初始版本金额
    private BigDecimal beforeChangeMny; // 变更前金额(不含税)
    private BigDecimal beforeChangeTaxMny; // 变更前金额
    private BigDecimal changingMny; // 变更中金额(不含税)
    private BigDecimal changingTaxMny; // 变更中金额
    private Long changeId; // 变更主键
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    @ConvertField
    private Integer changeStatus; // 变更状态：1-未变更，2-变更中，3-已变更
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private String changeContractSignatureStatus; // 变更合同签章状态
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    private Long changeFileId; // 变更附件Id
    private String changeContractName; // 变更合同名称
    private Long signedFileId; // 签章完成合同文件Id
    @ConvertField
    private Long mainContractId; // 主合同Id
    @ConvertField
    private String mainContractCode; // 主合同编码
    @ConvertField
    private String mainContractName; // 主合同名称
    private String supplementDescribe; // 补充项描述
    @ConvertField
    private Integer supplementFlag; // 是否补充协议：0-否，1-是
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate; // 主合同创建日期(用于合同、补充协议排序)
    @ConvertField
    private Long departmentId; // 经办部门
    @ConvertField
    private String departmentName; // 经办部门名称
    private String memo; // 备注

    private String signatureStatusName; // 签章状态名称
    private String billStateName; // 单据状态名称
    private String billPushFlag; // 推送供方状态
    private String projectNewType; // 项目类型分类

    private Long firstPartyEntrustedAgentId; // 甲方委托代理人id
    private String firstPartyEntrustedAgentName; // 甲方委托代理人名称
    private Long firstPartyPrincipalId; // 甲方负责人id
    private String firstPartyPrincipalName; // 甲方负责人名称
    private String firstPartyAddress; // 甲方地址
    private Long supplierPrincipalId; // 乙方单位负责人id
    private String supplierPrincipalName; // 乙方单位负责人名称
    private Long materialClerkOneId; // 材料员一id
    private String materialClerkOneName; // 材料员一名称
    private String materialClerkOnePhone; // 材料员一联系方式
    private Long materialClerkTwoId; // 材料员二id
    private String materialClerkTwoName; // 材料员二名称
    private String materialClerkTwoPhone; // 材料员二联系方式
    private String pushPoolFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    
    private List<ContractDailyRentVO> dailyRentList = new ArrayList<>(); // 周转材租赁合同-日租明细
    private List<ContractMonthRentVO> monthRentList = new ArrayList<>(); // 周转材租赁合同-月租明细
    private List<ContractNumRentVO> numRentList = new ArrayList<>(); // 周转材租赁合同-工程量租明细
    private List<ContractRepairVO> repairList = new ArrayList<>(); // 周转材租赁合同-维修标准
    private List<ContractScrapVO> scrapList = new ArrayList<>(); // 周转材租赁合同-报废标准
    private List<ContractOtherVO> otherList = new ArrayList<>(); // 周转材租赁合同-其他费用
    @ConvertField(targetField = "contractSubPaymentNodeList", targetFieldType = ConvertField.TargetType.CLASS)
    private List<ContractPaymentVO> paymentList = new ArrayList<>(); // 周转材租赁合同-付款阶段
    private List<ContractClauseVO> clauseList = new ArrayList<>(); // 周转材租赁合同-合同条款

    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyProjectManagerId() {
        return firstPartyProjectManagerId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyProjectManagerId(Long firstPartyProjectManagerId) {
        this.firstPartyProjectManagerId = firstPartyProjectManagerId;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyEmployeeId() {
        return firstPartyEmployeeId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyEmployeeId(Long firstPartyEmployeeId) {
        this.firstPartyEmployeeId = firstPartyEmployeeId;
    }

    public String getFirstPartyEmployeeName() {
        return firstPartyEmployeeName;
    }

    public void setFirstPartyEmployeeName(String firstPartyEmployeeName) {
        this.firstPartyEmployeeName = firstPartyEmployeeName;
    }

    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    @ReferDeserialTransfer
    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }

    public Date getRentCalculationDate() {
        return rentCalculationDate;
    }

    public void setRentCalculationDate(Date rentCalculationDate) {
        this.rentCalculationDate = rentCalculationDate;
    }

    public Date getEndRentCalculationDate() {
        return endRentCalculationDate;
    }

    public void setEndRentCalculationDate(Date endRentCalculationDate) {
        this.endRentCalculationDate = endRentCalculationDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getSupplyAddress() {
        return supplyAddress;
    }

    public void setSupplyAddress(String supplyAddress) {
        this.supplyAddress = supplyAddress;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(String changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSignatureStatusName() {
        return signatureStatusName;
    }

    public void setSignatureStatusName(String signatureStatusName) {
        this.signatureStatusName = signatureStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getProjectNewType() {
        return projectNewType;
    }

    public void setProjectNewType(String projectNewType) {
        this.projectNewType = projectNewType;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyEntrustedAgentId() {
        return firstPartyEntrustedAgentId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyEntrustedAgentId(Long firstPartyEntrustedAgentId) {
        this.firstPartyEntrustedAgentId = firstPartyEntrustedAgentId;
    }

    public String getFirstPartyEntrustedAgentName() {
        return firstPartyEntrustedAgentName;
    }

    public void setFirstPartyEntrustedAgentName(String firstPartyEntrustedAgentName) {
        this.firstPartyEntrustedAgentName = firstPartyEntrustedAgentName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyPrincipalId() {
        return firstPartyPrincipalId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyPrincipalId(Long firstPartyPrincipalId) {
        this.firstPartyPrincipalId = firstPartyPrincipalId;
    }

    public String getFirstPartyPrincipalName() {
        return firstPartyPrincipalName;
    }

    public void setFirstPartyPrincipalName(String firstPartyPrincipalName) {
        this.firstPartyPrincipalName = firstPartyPrincipalName;
    }

    public String getFirstPartyAddress() {
        return firstPartyAddress;
    }

    public void setFirstPartyAddress(String firstPartyAddress) {
        this.firstPartyAddress = firstPartyAddress;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getSupplierPrincipalId() {
        return supplierPrincipalId;
    }

    @ReferDeserialTransfer
    public void setSupplierPrincipalId(Long supplierPrincipalId) {
        this.supplierPrincipalId = supplierPrincipalId;
    }

    public String getSupplierPrincipalName() {
        return supplierPrincipalName;
    }

    public void setSupplierPrincipalName(String supplierPrincipalName) {
        this.supplierPrincipalName = supplierPrincipalName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getMaterialClerkOneId() {
        return materialClerkOneId;
    }

    @ReferDeserialTransfer
    public void setMaterialClerkOneId(Long materialClerkOneId) {
        this.materialClerkOneId = materialClerkOneId;
    }

    public String getMaterialClerkOneName() {
        return materialClerkOneName;
    }

    public void setMaterialClerkOneName(String materialClerkOneName) {
        this.materialClerkOneName = materialClerkOneName;
    }

    public String getMaterialClerkOnePhone() {
        return materialClerkOnePhone;
    }

    public void setMaterialClerkOnePhone(String materialClerkOnePhone) {
        this.materialClerkOnePhone = materialClerkOnePhone;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getMaterialClerkTwoId() {
        return materialClerkTwoId;
    }

    @ReferDeserialTransfer
    public void setMaterialClerkTwoId(Long materialClerkTwoId) {
        this.materialClerkTwoId = materialClerkTwoId;
    }

    public String getMaterialClerkTwoName() {
        return materialClerkTwoName;
    }

    public void setMaterialClerkTwoName(String materialClerkTwoName) {
        this.materialClerkTwoName = materialClerkTwoName;
    }

    public String getMaterialClerkTwoPhone() {
        return materialClerkTwoPhone;
    }

    public void setMaterialClerkTwoPhone(String materialClerkTwoPhone) {
        this.materialClerkTwoPhone = materialClerkTwoPhone;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public List<ContractDailyRentVO> getDailyRentList() {
        return dailyRentList;
    }

    public void setDailyRentList(List<ContractDailyRentVO> dailyRentList) {
        this.dailyRentList = dailyRentList;
    }

    public List<ContractMonthRentVO> getMonthRentList() {
        return monthRentList;
    }

    public void setMonthRentList(List<ContractMonthRentVO> monthRentList) {
        this.monthRentList = monthRentList;
    }

    public List<ContractNumRentVO> getNumRentList() {
        return numRentList;
    }

    public void setNumRentList(List<ContractNumRentVO> numRentList) {
        this.numRentList = numRentList;
    }

    public List<ContractRepairVO> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<ContractRepairVO> repairList) {
        this.repairList = repairList;
    }

    public List<ContractScrapVO> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<ContractScrapVO> scrapList) {
        this.scrapList = scrapList;
    }

    public List<ContractOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<ContractOtherVO> otherList) {
        this.otherList = otherList;
    }

    public List<ContractPaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<ContractPaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<ContractClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractClauseVO> clauseList) {
        this.clauseList = clauseList;
    }
}
