/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.util;

import com.ejianc.framework.cache.utils.RedisTool;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component(value="assistStoreLockUtil")
public class StoreLockUtil {
    @Autowired
    private JedisPool jedisPool2;
    private static JedisPool jedisPool;
    private static final String REQUEST_ID = "StoreSurplusUpdate";
    private static final String LOCK_KEY = "STOREKEY";
    private static StoreLockUtil util;

    @PostConstruct
    public void init() {
        util = this;
        jedisPool = this.jedisPool2;
    }

    public static Boolean getLock(Long storeId) {
        boolean locked = false;
        if (storeId != null) {
            Jedis jedis = jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)(LOCK_KEY + storeId), (String)REQUEST_ID, (int)1000);
            return locked;
        }
        return false;
    }

    public static void releaseLock(Long storeId) {
        if (storeId != null) {
            Jedis jedis = jedisPool.getResource();
            RedisTool.releaseLock((Jedis)jedis, (String)(LOCK_KEY + storeId), (String)REQUEST_ID);
            jedis.close();
        }
    }
}

