package com.ejianc.business.assist.store.vo;

import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 出入库封装VO
 * @date 2022/1/24
 */
@ApiModel("仓库管理API公共VO")
public class StoreManageVO implements Serializable {

    @ApiModelProperty(value = "仓库ID", required = true)
    private Long storeId;

    @ApiModelProperty(value = "业务单据主表ID", required = true)
    private Long sourceId;

    /**
     * 出入库类型 必须有
     */
    @ApiModelProperty(value = "出入库类型", required = true)
    private InOutTypeEnum inOutTypeEnum;

    /**
     * 出入库流水数据 必须有
     */
    @ApiModelProperty(value = "入库/出库(正向)流水")
    private List<FlowVO> flowVOList;

    /**
     * 直入直出类型,出库单数据
     */
    @ApiModelProperty(value = "直入直出的出库流水")
    private List<FlowVO> straightOutFlowVOList;

    /**
     * 出库入参 必须, false 出库单未生效, true 出库单生效
     */
    @ApiModelProperty(value = "出库单生效标志", required = true, notes = "保存/删除放false,审批通过/弃审放true")
    private Boolean outEffectiveON = false;

    /**
     * 回滚时使用,主要是入库弃审,出库删除
     */
    @ApiModelProperty(value = "来源单据ID集合", notes = "入库弃审/出库弃审和删除")
    private List<Long> sourceIdsForRollBack;

    /**
     * 物资现存量,价格VO,查询物资现存量库存均价使用
     */
    @ApiModelProperty(value = "现存量库存均价", notes = "根据先进先出计算出来返回的的物资价格VO")
    private List<UseMaterialPriceVO> useMaterialPriceVOList;

    /**
     * 入库回参 入库后当前这些物资的库存量
     */
    @ApiModelProperty(value = "仓库的库存VO", notes = "返回当前的仓库的物资库存")
    private List<SurplusVO> surplusVOList;


    public InOutTypeEnum getInOutTypeEnum() {
        return inOutTypeEnum;
    }

    public void setInOutTypeEnum(InOutTypeEnum inOutTypeEnum) {
        this.inOutTypeEnum = inOutTypeEnum;
    }

    public List<FlowVO> getFlowVOList() {
        return flowVOList;
    }

    public void setFlowVOList(List<FlowVO> flowVOList) {
        this.flowVOList = flowVOList;
    }

    public List<SurplusVO> getSurplusVOList() {
        return surplusVOList;
    }

    public void setSurplusVOList(List<SurplusVO> surplusVOList) {
        this.surplusVOList = surplusVOList;
    }

    public Boolean getOutEffectiveON() {
        return outEffectiveON;
    }

    public void setOutEffectiveON(Boolean outEffectiveON) {
        this.outEffectiveON = outEffectiveON;
    }

    public List<UseMaterialPriceVO> getUseMaterialPriceVOList() {
        return useMaterialPriceVOList;
    }

    public void setUseMaterialPriceVOList(List<UseMaterialPriceVO> useMaterialPriceVOList) {
        this.useMaterialPriceVOList = useMaterialPriceVOList;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public List<FlowVO> getStraightOutFlowVOList() {
        return straightOutFlowVOList;
    }

    public void setStraightOutFlowVOList(List<FlowVO> straightOutFlowVOList) {
        this.straightOutFlowVOList = straightOutFlowVOList;
    }

    public List<Long> getSourceIdsForRollBack() {
        return sourceIdsForRollBack;
    }

    public void setSourceIdsForRollBack(List<Long> sourceIdsForRollBack) {
        this.sourceIdsForRollBack = sourceIdsForRollBack;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
}
