package com.ejianc.business.outrmat.settle.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 周转材租赁结算单
 *
 * @author generator
 */
public class OutRmatSettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ConvertField
    private String billCode; // 单据编号
    @ConvertField
    private Integer billState; // 单据状态
    @ConvertField
    private Long projectId; // 项目id
    @ConvertField
    private String projectCode; // 项目编码
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private Long orgId; // 项目组织id
    @ConvertField
    private String orgCode; // 项目组织编码
    @ConvertField
    private String orgName; // 项目组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织id
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    @ConvertField
    private Long contractId; // 合同id
    @ConvertField
    private String contractName; // 合同名称
    @ConvertField(targetField = "partyaId")
    private Long firstPartyId; // 甲方Id
    @ConvertField(targetField = "partyaName")
    private String firstPartyName; // 甲方名称
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 乙方Id
    @ConvertField(targetField = "partybName")
    private String supplierName; // 乙方名称
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private Integer monthSettlementDay; // 月结算日
    private String settleType; // 结算类型：0-过程结算，1-最终结算
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    @ConvertField
    private Long employeeId; // 经办人id
    @ConvertField
    private String employeeName; // 经办人名称
    @ConvertField
    private Long departmentId; // 经办部门
    @ConvertField
    private String departmentName; // 经办部门名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date supOperateTime; // 供方经办人签字时间
    private Integer supplierSignStatus; // 供方签字状态：0-未签字，1-已签字
    @ConvertField
    private String memo; // 备注
    @ConvertField(targetField = "curTaxMny")
    private BigDecimal settleTaxMny; // 本期结算金额
    @ConvertField(targetField = "curMny")
    private BigDecimal settleMny; // 本期结算金额(无税)
    @ConvertField(targetField = "curTax")
    private BigDecimal settleTax; // 本期结算税额
    private BigDecimal leaseTaxMny; // 租赁金额
    private BigDecimal leaseMny; // 租赁金额(无税)
    private BigDecimal leaseTax; // 租赁税额
    private BigDecimal rentTaxMny; // 租金计算单金额
    private BigDecimal rentMny; // 租金计算单金额(无税)
    private BigDecimal rentTax; // 租金计算单税额
    private BigDecimal dailyRentTaxMny; // 日租金额
    private BigDecimal dailyRentMny; // 日租金额(无税)
    private BigDecimal dailyRentTax; // 日租税额
    private BigDecimal monthRentTaxMny; // 月租金额
    private BigDecimal monthRentMny; // 月租金额(无税)
    private BigDecimal monthRentTax; // 月租税额
    private BigDecimal numRentTaxMny; // 工程量金额
    private BigDecimal numRentMny; // 工程量金额(无税)
    private BigDecimal numRentTax; // 工程量税额
    private BigDecimal repairTaxMny; // 维修金额
    private BigDecimal repairMny; // 维修金额(无税)
    private BigDecimal repairTax; // 维修税额
    private BigDecimal scarpTaxMny; // 报废赔偿金额
    private BigDecimal scarpMny; // 报废赔偿金额(无税)
    private BigDecimal scarpTax; // 报废赔偿税额
    private BigDecimal loseTaxMny; // 遗失赔偿金额
    private BigDecimal loseMny; // 遗失赔偿金额(无税)
    private BigDecimal loseTax; // 遗失赔偿税额
    private BigDecimal otherTaxMny; // 其他金额
    private BigDecimal otherMny; // 其他金额(无税)
    private BigDecimal otherTax; // 其他税额
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额(无税)
    private BigDecimal contractTax; // 合同税额
    @ConvertField(targetField = "lastTaxMny")
    private BigDecimal lastSettleTaxMny; // 不含本期已结算金额
    @ConvertField(targetField = "lastMny")
    private BigDecimal lastSettleMny; // 不含本期已结算金额(无税)
    @ConvertField(targetField = "lastTax")
    private BigDecimal lastSettleTax; // 不含本期已结算税额
    private BigDecimal totalSettleTaxMny; // 含本期已结算金额
    private BigDecimal totalSettleMny; // 含本期已结算金额(无税)
    private BigDecimal totalSettleTax; // 含本期已结算税额
    private BigDecimal totalPayTaxMny; // 累计已付金额
    private BigDecimal totalPayMny; // 累计已付金额(无税)
    private BigDecimal totalPayTax; // 累计已付税额
    private BigDecimal totalInvoiceTaxMny; // 累计收票金额
    private BigDecimal totalInvoiceMny; // 累计收票金额(无税)
    private BigDecimal totalInvoiceTax; // 累计收票税额
    private BigDecimal contractPayRate; // 合同支付比例
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交时间
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号

    private BigDecimal contractTaxRate; // 合同税率
    @ConvertField
    private String contractCode; // 合同编号
    private String supplierSignStatusName; // 签字状态名称
    private String billStateName; // 单据状态名称
    private String pushPoolFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private String supOperatorName; // 供方经办人名称
    private String supOperatorPhone; // 供方经办人手机号
    private String supOperatorUserCode; // 供方经办人账号
    private Long outOrgId; // 租出单位id
    private String outOrgCode; // 租出单位code
    private String outOrgName; // 租出单位name

    private List<OutRmatSettleLeaseVO> leaseList = new ArrayList<>(); // 结算单-租赁金额
    private List<OutRmatSettleDailyRentVO> dailyRentList = new ArrayList<>(); // 结算单-日租金额
    private List<OutRmatSettleMonthRentVO> monthRentList = new ArrayList<>(); // 结算单-月租金额
    private List<OutRmatSettleNumRentVO> numRentList = new ArrayList<>(); // 结算单-工程量租金额
    private List<OutRmatSettleRepairVO> repairList = new ArrayList<>(); // 结算单-维修金额
    private List<OutRmatSettleScrapVO> scrapList = new ArrayList<>(); // 结算单-报废赔偿金额
    private List<OutRmatSettleLoseVO> loseList = new ArrayList<>(); // 结算单-遗失赔偿金额
    private List<OutRmatSettleOtherVO> otherList = new ArrayList<>(); // 结算单-其他费用

    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    
    @ReferSerialTransfer(referCode = "arri_contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public BigDecimal getLeaseTaxMny() {
        return leaseTaxMny;
    }

    public void setLeaseTaxMny(BigDecimal leaseTaxMny) {
        this.leaseTaxMny = leaseTaxMny;
    }

    public BigDecimal getLeaseMny() {
        return leaseMny;
    }

    public void setLeaseMny(BigDecimal leaseMny) {
        this.leaseMny = leaseMny;
    }

    public BigDecimal getLeaseTax() {
        return leaseTax;
    }

    public void setLeaseTax(BigDecimal leaseTax) {
        this.leaseTax = leaseTax;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }

    public BigDecimal getDailyRentTaxMny() {
        return dailyRentTaxMny;
    }

    public void setDailyRentTaxMny(BigDecimal dailyRentTaxMny) {
        this.dailyRentTaxMny = dailyRentTaxMny;
    }

    public BigDecimal getDailyRentMny() {
        return dailyRentMny;
    }

    public void setDailyRentMny(BigDecimal dailyRentMny) {
        this.dailyRentMny = dailyRentMny;
    }

    public BigDecimal getDailyRentTax() {
        return dailyRentTax;
    }

    public void setDailyRentTax(BigDecimal dailyRentTax) {
        this.dailyRentTax = dailyRentTax;
    }

    public BigDecimal getMonthRentTaxMny() {
        return monthRentTaxMny;
    }

    public void setMonthRentTaxMny(BigDecimal monthRentTaxMny) {
        this.monthRentTaxMny = monthRentTaxMny;
    }

    public BigDecimal getMonthRentMny() {
        return monthRentMny;
    }

    public void setMonthRentMny(BigDecimal monthRentMny) {
        this.monthRentMny = monthRentMny;
    }

    public BigDecimal getMonthRentTax() {
        return monthRentTax;
    }

    public void setMonthRentTax(BigDecimal monthRentTax) {
        this.monthRentTax = monthRentTax;
    }

    public BigDecimal getNumRentTaxMny() {
        return numRentTaxMny;
    }

    public void setNumRentTaxMny(BigDecimal numRentTaxMny) {
        this.numRentTaxMny = numRentTaxMny;
    }

    public BigDecimal getNumRentMny() {
        return numRentMny;
    }

    public void setNumRentMny(BigDecimal numRentMny) {
        this.numRentMny = numRentMny;
    }

    public BigDecimal getNumRentTax() {
        return numRentTax;
    }

    public void setNumRentTax(BigDecimal numRentTax) {
        this.numRentTax = numRentTax;
    }

    public BigDecimal getRepairTaxMny() {
        return repairTaxMny;
    }

    public void setRepairTaxMny(BigDecimal repairTaxMny) {
        this.repairTaxMny = repairTaxMny;
    }

    public BigDecimal getRepairMny() {
        return repairMny;
    }

    public void setRepairMny(BigDecimal repairMny) {
        this.repairMny = repairMny;
    }

    public BigDecimal getRepairTax() {
        return repairTax;
    }

    public void setRepairTax(BigDecimal repairTax) {
        this.repairTax = repairTax;
    }

    public BigDecimal getScarpTaxMny() {
        return scarpTaxMny;
    }

    public void setScarpTaxMny(BigDecimal scarpTaxMny) {
        this.scarpTaxMny = scarpTaxMny;
    }

    public BigDecimal getScarpMny() {
        return scarpMny;
    }

    public void setScarpMny(BigDecimal scarpMny) {
        this.scarpMny = scarpMny;
    }

    public BigDecimal getScarpTax() {
        return scarpTax;
    }

    public void setScarpTax(BigDecimal scarpTax) {
        this.scarpTax = scarpTax;
    }

    public BigDecimal getLoseTaxMny() {
        return loseTaxMny;
    }

    public void setLoseTaxMny(BigDecimal loseTaxMny) {
        this.loseTaxMny = loseTaxMny;
    }

    public BigDecimal getLoseMny() {
        return loseMny;
    }

    public void setLoseMny(BigDecimal loseMny) {
        this.loseMny = loseMny;
    }

    public BigDecimal getLoseTax() {
        return loseTax;
    }

    public void setLoseTax(BigDecimal loseTax) {
        this.loseTax = loseTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getLastSettleTaxMny() {
        return lastSettleTaxMny;
    }

    public void setLastSettleTaxMny(BigDecimal lastSettleTaxMny) {
        this.lastSettleTaxMny = lastSettleTaxMny;
    }

    public BigDecimal getLastSettleMny() {
        return lastSettleMny;
    }

    public void setLastSettleMny(BigDecimal lastSettleMny) {
        this.lastSettleMny = lastSettleMny;
    }

    public BigDecimal getLastSettleTax() {
        return lastSettleTax;
    }

    public void setLastSettleTax(BigDecimal lastSettleTax) {
        this.lastSettleTax = lastSettleTax;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTax() {
        return totalSettleTax;
    }

    public void setTotalSettleTax(BigDecimal totalSettleTax) {
        this.totalSettleTax = totalSettleTax;
    }

    public BigDecimal getTotalPayTaxMny() {
        return totalPayTaxMny;
    }

    public void setTotalPayTaxMny(BigDecimal totalPayTaxMny) {
        this.totalPayTaxMny = totalPayTaxMny;
    }

    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }

    public BigDecimal getTotalPayTax() {
        return totalPayTax;
    }

    public void setTotalPayTax(BigDecimal totalPayTax) {
        this.totalPayTax = totalPayTax;
    }

    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }

    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }

    public BigDecimal getTotalInvoiceTax() {
        return totalInvoiceTax;
    }

    public void setTotalInvoiceTax(BigDecimal totalInvoiceTax) {
        this.totalInvoiceTax = totalInvoiceTax;
    }

    public BigDecimal getContractPayRate() {
        return contractPayRate;
    }

    public void setContractPayRate(BigDecimal contractPayRate) {
        this.contractPayRate = contractPayRate;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getSupplierSignStatusName() {
        return supplierSignStatusName;
    }

    public void setSupplierSignStatusName(String supplierSignStatusName) {
        this.supplierSignStatusName = supplierSignStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public List<OutRmatSettleLeaseVO> getLeaseList() {
        return leaseList;
    }

    public void setLeaseList(List<OutRmatSettleLeaseVO> leaseList) {
        this.leaseList = leaseList;
    }

    public List<OutRmatSettleDailyRentVO> getDailyRentList() {
        return dailyRentList;
    }

    public void setDailyRentList(List<OutRmatSettleDailyRentVO> dailyRentList) {
        this.dailyRentList = dailyRentList;
    }

    public List<OutRmatSettleMonthRentVO> getMonthRentList() {
        return monthRentList;
    }

    public void setMonthRentList(List<OutRmatSettleMonthRentVO> monthRentList) {
        this.monthRentList = monthRentList;
    }

    public List<OutRmatSettleNumRentVO> getNumRentList() {
        return numRentList;
    }

    public void setNumRentList(List<OutRmatSettleNumRentVO> numRentList) {
        this.numRentList = numRentList;
    }

    public List<OutRmatSettleRepairVO> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<OutRmatSettleRepairVO> repairList) {
        this.repairList = repairList;
    }

    public List<OutRmatSettleScrapVO> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<OutRmatSettleScrapVO> scrapList) {
        this.scrapList = scrapList;
    }

    public List<OutRmatSettleLoseVO> getLoseList() {
        return loseList;
    }

    public void setLoseList(List<OutRmatSettleLoseVO> loseList) {
        this.loseList = loseList;
    }

    public List<OutRmatSettleOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<OutRmatSettleOtherVO> otherList) {
        this.otherList = otherList;
    }
}
