package com.ejianc.business.outrmat.utils;

import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.stereotype.Component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

@Component("outRmatAssistSortUtil")
public class SortUtil<T> {

    //实现排序
    public List<T> entryListToSort(List<T> list,String indexName) {
        list.sort((o1, o2) -> {
            Class<?> mainClass = o1.getClass();
            String[] preArrs = getValue(o1, indexName).split("\\.");
            String[] sufArrs = getValue(o2, indexName).split("\\.");
            int len = preArrs.length > sufArrs.length ? preArrs.length : sufArrs.length;
            for (int i = 0; i < len; i++) {
                int preNum = 0;
                int sufNum = 0;

                if (i < preArrs.length) {
                    preNum = Integer.parseInt(preArrs[i]);
                }

                if (i < sufArrs.length) {
                    sufNum = Integer.parseInt(sufArrs[i]);
                }

                if (preNum > sufNum) {
                    return 1;
                } else if (preNum < sufNum) {
                    return -1;
                }
            }
            return 0;
        });
        return list;
    }

    private String getValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), (Class[]) null);
            try {
                String value = (String) m.invoke(t, (Object[]) null);
                return value;
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置get方法！");
        }
    }
}
