package com.ejianc.business.outrmat.contract.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeEnum {

//    租赁订单("租赁订单", "BT220322000000001"),
//    验收单("验收单", "BT220322000000002"),
//    启用单("启用单", "BT220322000000006"),
//    停用单("停用单", "BT220322000000007"),
//    退赔单("退赔单", "BT220322000000004"),
//    遗失单("遗失单", "BT220322000000005"),
//    辅料中心租入合同("辅料中心租入合同", "BT220322000000009"),
//    辅料中心租入合同变更("辅料中心租入合同变更", "BT220322000000010"),
//    辅料中心租入合同记录("辅料中心租入合同记录", "BT220322000000011"),
//    租金计算单("租金计算单", "BT220322000000008"),
//    辅料中心租入合同解除("辅料中心租入合同解除", "BT220322000000012"),
//    辅料中心租入合同结算单("辅料中心租入合同结算单", "BT220322000000014"),

    辅料中心租出合同("辅料中心租出合同","EJCBT202209000004"),
    辅料中心租出合同变更("辅料中心租出合同变更","EJCBT202209000005"),
    辅料中心租出合同记录("辅料中心租出合同记录","EJCBT202209000008"),
    辅料中心租出合同解除("辅料中心租出合同解除", "EJCBT202209000006"),
    辅料中心租出合同结算单("辅料中心租出合同结算单", "EJCBT202209000011"),
    租出遗失单("租出遗失单", "EJCBT202209000010"),
    租出订单("租出订单", "EJCBT202209000014"),
    ;

    private final String name;
    private final String code;
    private static Map<String, BillTypeEnum> enumMap = new HashMap();

    private BillTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BillTypeEnum getEnumByName(String billTypeName) {
        return (BillTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeEnum.class).stream().collect(Collectors.toMap(BillTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
