package com.ejianc.business.assist.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 遗失单材料清单明细
 * 
 * @author generator
 * 
 */
public class LoseDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long materialId; // 物料主键
    private String materialName; // 物料名称
    private Long materialTypeId; // 物料分类
    private String materialTypeName; // 物料分类名称
    private String materialCode; // 物料编码
    private String unitName; // 计量单位
    private String spec; // 规格型号
    private BigDecimal loseTaxPrice; // 遗失单价
    private BigDecimal losePrice; // 遗失单价(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal exitNum; // 可退场数量
    private BigDecimal loseNum; // 遗失数量
    private BigDecimal compensationMny; // 赔偿金额(无税)
    private BigDecimal compensationTaxMny; // 赔偿金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 止租日期
    private String memo; // 备注
    private Long loseId; // 遗失单主键
    private Long unitId; // 单位主键
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private String useStatus; // 使用状态：0-停用，1-启用
    private String sourceId; // 来源主键
    private BigDecimal loseUnitTaxPrice; // 遗失单价
    private BigDecimal tax; //赔偿税额
    private Long unitMId; // 计量单位主键
    private String unitMName; // 计量单位
    private BigDecimal numM; // 计量数量
    private BigDecimal transScale; // 转换系数

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getLosePrice() {
        return losePrice;
    }

    public void setLosePrice(BigDecimal losePrice) {
        this.losePrice = losePrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getExitNum() {
        return exitNum;
    }

    public void setExitNum(BigDecimal exitNum) {
        this.exitNum = exitNum;
    }
    public BigDecimal getLoseNum() {
        return loseNum;
    }

    public void setLoseNum(BigDecimal loseNum) {
        this.loseNum = loseNum;
    }
    public BigDecimal getCompensationMny() {
        return compensationMny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public void setCompensationMny(BigDecimal compensationMny) {
        this.compensationMny = compensationMny;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getLoseId() {
        return loseId;
    }

    public void setLoseId(Long loseId) {
        this.loseId = loseId;
    }
    @ReferSerialTransfer(referCode = "share-unit")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }

    public BigDecimal getLoseTaxPrice() {
        return loseTaxPrice;
    }

    public void setLoseTaxPrice(BigDecimal loseTaxPrice) {
        this.loseTaxPrice = loseTaxPrice;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public BigDecimal getLoseUnitTaxPrice() {
        return loseUnitTaxPrice;
    }

    public void setLoseUnitTaxPrice(BigDecimal loseUnitTaxPrice) {
        this.loseUnitTaxPrice = loseUnitTaxPrice;
    }

    public BigDecimal getCompensationTaxMny() {
        return compensationTaxMny;
    }

    public void setCompensationTaxMny(BigDecimal compensationTaxMny) {
        this.compensationTaxMny = compensationTaxMny;
    }

    public Long getUnitMId() {
        return unitMId;
    }
     
    public void setUnitMId(Long unitMId) {
        this.unitMId = unitMId;
    }

    public String getUnitMName() {
        return unitMName;
    }

    public void setUnitMName(String unitMName) {
        this.unitMName = unitMName;
    }

    public BigDecimal getNumM() {
        return numM;
    }

    public void setNumM(BigDecimal numM) {
        this.numM = numM;
    }

    public BigDecimal getTransScale() {
        return transScale;
    }

    public void setTransScale(BigDecimal transScale) {
        this.transScale = transScale;
    }
}
