package com.ejianc.business.assist.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 结算单-工程量租金额
 *
 * @author generator
 */
public class SettleNumRentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long settleId; // 结算id
    private Long sourceId; // 来源数据Id
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String spec; // 规格/型号
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位名称
    private BigDecimal num; // 数量
    private BigDecimal unitTaxPrice; // 租赁单价
    private BigDecimal unitPrice; // 租赁单价(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal numRentTaxMny; // 工程量租金
    private BigDecimal numRentMny; // 工程量租金(无税)
    private BigDecimal numTax; // 税额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 计费开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 计费结束日期
    private String memo; // 备注


    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    @ReferSerialTransfer(referCode = "share-unit")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getNumRentTaxMny() {
        return numRentTaxMny;
    }

    public void setNumRentTaxMny(BigDecimal numRentTaxMny) {
        this.numRentTaxMny = numRentTaxMny;
    }

    public BigDecimal getNumRentMny() {
        return numRentMny;
    }

    public void setNumRentMny(BigDecimal numRentMny) {
        this.numRentMny = numRentMny;
    }

    public BigDecimal getNumTax() {
        return numTax;
    }

    public void setNumTax(BigDecimal numTax) {
        this.numTax = numTax;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
